"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var MetadataRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataRepository = void 0;
const common_1 = require("@nestjs/common");
const exiftool_vendored_1 = require("exiftool-vendored");
const geo_tz_1 = __importDefault(require("geo-tz"));
const logging_repository_1 = require("./logging.repository");
let MetadataRepository = MetadataRepository_1 = class MetadataRepository {
    logger;
    exiftool = new exiftool_vendored_1.ExifTool({
        defaultVideosToUTC: true,
        backfillTimezones: true,
        inferTimezoneFromDatestamps: true,
        inferTimezoneFromTimeStamp: true,
        useMWG: true,
        numericTags: [...exiftool_vendored_1.DefaultReadTaskOptions.numericTags, 'FocalLength', 'FileSize'],
        geoTz: (lat, lon) => geo_tz_1.default.find(lat, lon)[0],
        readArgs: ['-api', 'largefilesupport=1'],
        writeArgs: ['-api', 'largefilesupport=1', '-overwrite_original'],
    });
    constructor(logger) {
        this.logger = logger;
        this.logger.setContext(MetadataRepository_1.name);
    }
    setMaxConcurrency(concurrency) {
        this.exiftool.batchCluster.setMaxProcs(concurrency);
    }
    async teardown() {
        await this.exiftool.end();
    }
    readTags(path) {
        return this.exiftool.read(path).catch((error) => {
            this.logger.warn(`Error reading exif data (${path}): ${error}\n${error?.stack}`);
            return {};
        });
    }
    extractBinaryTag(path, tagName) {
        return this.exiftool.extractBinaryTagToBuffer(tagName, path);
    }
    async writeTags(path, tags) {
        try {
            await this.exiftool.write(path, tags);
        }
        catch (error) {
            this.logger.warn(`Error writing exif data (${path}): ${error}`);
        }
    }
};
exports.MetadataRepository = MetadataRepository;
exports.MetadataRepository = MetadataRepository = MetadataRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository])
], MetadataRepository);
//# sourceMappingURL=metadata.repository.js.map