import { Kysely } from 'kysely';
import { MapAsset } from 'src/dtos/asset-response.dto';
import { AssetStatus, AssetType, AssetVisibility } from 'src/enum';
import { DB } from 'src/schema';
export interface SearchAssetIdOptions {
    checksum?: Buffer;
    deviceAssetId?: string;
    id?: string;
}
export interface SearchUserIdOptions {
    deviceId?: string;
    libraryId?: string | null;
    userIds?: string[];
}
export type SearchIdOptions = SearchAssetIdOptions & SearchUserIdOptions;
export interface SearchStatusOptions {
    isEncoded?: boolean;
    isFavorite?: boolean;
    isMotion?: boolean;
    isOffline?: boolean;
    isNotInAlbum?: boolean;
    type?: AssetType;
    status?: AssetStatus;
    withArchived?: boolean;
    withDeleted?: boolean;
    visibility?: AssetVisibility;
}
export interface SearchOneToOneRelationOptions {
    withExif?: boolean;
    withStacked?: boolean;
}
export interface SearchRelationOptions extends SearchOneToOneRelationOptions {
    withFaces?: boolean;
    withPeople?: boolean;
}
export interface SearchDateOptions {
    createdBefore?: Date;
    createdAfter?: Date;
    takenBefore?: Date;
    takenAfter?: Date;
    trashedBefore?: Date;
    trashedAfter?: Date;
    updatedBefore?: Date;
    updatedAfter?: Date;
}
export interface SearchPathOptions {
    encodedVideoPath?: string;
    originalFileName?: string;
    originalPath?: string;
    previewPath?: string;
    thumbnailPath?: string;
}
export interface SearchExifOptions {
    city?: string | null;
    country?: string | null;
    lensModel?: string | null;
    make?: string | null;
    model?: string | null;
    state?: string | null;
    description?: string | null;
    rating?: number | null;
}
export interface SearchEmbeddingOptions {
    embedding: string;
    userIds: string[];
}
export interface SearchPeopleOptions {
    personIds?: string[];
}
export interface SearchTagOptions {
    tagIds?: string[] | null;
}
export interface SearchAlbumOptions {
    albumIds?: string[];
}
export interface SearchOrderOptions {
    orderDirection?: 'asc' | 'desc';
}
export interface SearchPaginationOptions {
    page: number;
    size: number;
}
type BaseAssetSearchOptions = SearchDateOptions & SearchIdOptions & SearchExifOptions & SearchOrderOptions & SearchPathOptions & SearchStatusOptions & SearchUserIdOptions & SearchPeopleOptions & SearchTagOptions & SearchAlbumOptions;
export type AssetSearchOptions = BaseAssetSearchOptions & SearchRelationOptions;
export type AssetSearchBuilderOptions = Omit<AssetSearchOptions, 'orderDirection'>;
export type SmartSearchOptions = SearchDateOptions & SearchEmbeddingOptions & SearchExifOptions & SearchOneToOneRelationOptions & SearchStatusOptions & SearchUserIdOptions & SearchPeopleOptions & SearchTagOptions;
export type LargeAssetSearchOptions = AssetSearchOptions & {
    minFileSize?: number;
};
export interface FaceEmbeddingSearch extends SearchEmbeddingOptions {
    hasPerson?: boolean;
    numResults: number;
    maxDistance: number;
    minBirthDate?: Date | null;
}
export interface FaceSearchResult {
    distance: number;
    id: string;
    personId: string | null;
}
export interface AssetDuplicateResult {
    assetId: string;
    duplicateId: string | null;
    distance: number;
}
export interface GetStatesOptions {
    country?: string;
}
export interface GetCitiesOptions extends GetStatesOptions {
    state?: string;
}
export interface GetCameraModelsOptions {
    make?: string;
}
export interface GetCameraMakesOptions {
    model?: string;
}
export declare class SearchRepository {
    private db;
    constructor(db: Kysely<DB>);
    searchMetadata(pagination: SearchPaginationOptions, options: AssetSearchOptions): Promise<import("src/utils/pagination").PaginationResult<{
        exifInfo?: import("../database").Exif | undefined;
        faces?: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            person: import("../database").Person;
        }[] | undefined;
        id: string;
        type: AssetType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        updateId: string;
        ownerId: string;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        stackId: string | null;
        duplicateId: string | null;
        visibility: AssetVisibility;
    }>>;
    searchStatistics(options: AssetSearchOptions): Promise<{
        exifInfo?: import("../database").Exif | undefined;
        faces?: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            person: import("../database").Person;
        }[] | undefined;
        total: number;
    }>;
    searchRandom(size: number, options: AssetSearchOptions): Promise<MapAsset[]>;
    searchLargeAssets(size: number, options: LargeAssetSearchOptions): Promise<{
        exifInfo: import("../database").Exif;
        faces?: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            person: import("../database").Person;
        }[] | undefined;
        id: string;
        type: AssetType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        updateId: string;
        ownerId: string;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        stackId: string | null;
        duplicateId: string | null;
        visibility: AssetVisibility;
    }[]>;
    searchSmart(pagination: SearchPaginationOptions, options: SmartSearchOptions): Promise<import("src/utils/pagination").PaginationResult<{
        exifInfo?: import("../database").Exif | undefined;
        faces?: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            person: import("../database").Person;
        }[] | undefined;
        id: string;
        type: AssetType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        updateId: string;
        ownerId: string;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        stackId: string | null;
        duplicateId: string | null;
        visibility: AssetVisibility;
    }>>;
    getEmbedding(assetId: string): Promise<{
        assetId: string;
        embedding: string;
    } | undefined>;
    searchFaces({ userIds, embedding, numResults, maxDistance, hasPerson, minBirthDate }: FaceEmbeddingSearch): Promise<{
        id: string;
        personId: string | null;
        distance: number;
    }[]>;
    searchPlaces(placeName: string): Promise<{
        id: number;
        name: string;
        latitude: number;
        longitude: number;
        countryCode: string;
        admin1Code: string | null;
        admin2Code: string | null;
        modificationDate: Date;
        admin1Name: string | null;
        admin2Name: string | null;
        alternateNames: string | null;
    }[]>;
    getAssetsByCity(userIds: string[]): Promise<{
        id: string;
        type: AssetType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        status: AssetStatus;
        updateId: string;
        ownerId: string;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        stackId: string | null;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo: {
            description: string;
            assetId: string;
            updatedAt: Date;
            updateId: string;
            make: string | null;
            model: string | null;
            exifImageWidth: number | null;
            exifImageHeight: number | null;
            fileSizeInByte: number | null;
            orientation: string | null;
            dateTimeOriginal: Date | null;
            modifyDate: Date | null;
            lensModel: string | null;
            fNumber: number | null;
            focalLength: number | null;
            iso: number | null;
            latitude: number | null;
            longitude: number | null;
            city: string | null;
            state: string | null;
            country: string | null;
            fps: number | null;
            exposureTime: string | null;
            livePhotoCID: string | null;
            timeZone: string | null;
            projectionType: string | null;
            profileDescription: string | null;
            colorspace: string | null;
            bitsPerSample: number | null;
            autoStackId: string | null;
            rating: number | null;
        };
    }[]>;
    upsert(assetId: string, embedding: string): Promise<void>;
    getCountries(userIds: string[]): Promise<string[]>;
    getStates(userIds: string[], { country }: GetStatesOptions): Promise<string[]>;
    getCities(userIds: string[], { country, state }: GetCitiesOptions): Promise<string[]>;
    getCameraMakes(userIds: string[], { model }: GetCameraMakesOptions): Promise<string[]>;
    getCameraModels(userIds: string[], { make }: GetCameraModelsOptions): Promise<string[]>;
    private getExifField;
}
export {};
