import { Insertable, Kysely, Updateable } from 'kysely';
import { DB } from 'src/schema';
import { SessionTable } from 'src/schema/tables/session.table';
export type SessionSearchOptions = {
    updatedBefore: Date;
};
export declare class SessionRepository {
    private db;
    constructor(db: Kysely<DB>);
    cleanup(): Promise<{
        id: string;
        deviceType: string;
        deviceOS: string;
    }[]>;
    get(id: string): Promise<{
        id: string;
        expiresAt: Date | null;
        pinExpiresAt: Date | null;
    } | undefined>;
    isPendingSyncReset(id: string): Promise<boolean>;
    getByToken(token: string): Promise<{
        id: string;
        updatedAt: Date;
        pinExpiresAt: Date | null;
        user: {
            id: string;
            name: string;
            email: string;
            isAdmin: boolean;
            quotaSizeInBytes: number | null;
            quotaUsageInBytes: number;
        } | null;
    } | undefined>;
    getByUserId(userId: string): Promise<{
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        userId: string;
        token: string;
        expiresAt: Date | null;
        parentId: string | null;
        deviceType: string;
        deviceOS: string;
        isPendingSyncReset: boolean;
        pinExpiresAt: Date | null;
    }[]>;
    create(dto: Insertable<SessionTable>): Promise<{
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        userId: string;
        token: string;
        expiresAt: Date | null;
        parentId: string | null;
        deviceType: string;
        deviceOS: string;
        isPendingSyncReset: boolean;
        pinExpiresAt: Date | null;
    }>;
    update(id: string, dto: Updateable<SessionTable>): Promise<{
        id: string;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        userId: string;
        token: string;
        expiresAt: Date | null;
        parentId: string | null;
        deviceType: string;
        deviceOS: string;
        isPendingSyncReset: boolean;
        pinExpiresAt: Date | null;
    }>;
    delete(id: string): Promise<void>;
    lockAll(userId: string): Promise<void>;
    resetSyncProgress(sessionId: string): Promise<void>;
}
