"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const database_2 = require("../utils/database");
const withAssets = (eb, withTags = false) => {
    return (0, postgres_1.jsonArrayFrom)(eb
        .selectFrom('asset')
        .selectAll('asset')
        .innerJoinLateral((eb) => eb
        .selectFrom('asset_exif')
        .select(database_1.columns.exif)
        .whereRef('asset_exif.assetId', '=', 'asset.id')
        .as('exifInfo'), (join) => join.onTrue())
        .$if(withTags, (eb) => eb.select((eb) => (0, postgres_1.jsonArrayFrom)(eb
        .selectFrom('tag')
        .select(database_1.columns.tag)
        .innerJoin('tag_asset', 'tag.id', 'tag_asset.tagsId')
        .whereRef('tag_asset.assetsId', '=', 'asset.id')).as('tags')))
        .select((eb) => eb.fn.toJson('exifInfo').as('exifInfo'))
        .where('asset.deletedAt', 'is', null)
        .whereRef('asset.stackId', '=', 'stack.id')
        .$call(database_2.withDefaultVisibility)).as('assets');
};
let StackRepository = class StackRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    search(query) {
        return this.db
            .selectFrom('stack')
            .selectAll('stack')
            .select(withAssets)
            .where('stack.ownerId', '=', query.ownerId)
            .$if(!!query.primaryAssetId, (eb) => eb.where('stack.primaryAssetId', '=', query.primaryAssetId))
            .execute();
    }
    async create(entity, assetIds) {
        return this.db.transaction().execute(async (tx) => {
            const stacks = await tx
                .selectFrom('stack')
                .where('stack.ownerId', '=', entity.ownerId)
                .where('stack.primaryAssetId', 'in', assetIds)
                .select('stack.id')
                .select((eb) => (0, postgres_1.jsonArrayFrom)(eb
                .selectFrom('asset')
                .select('asset.id')
                .whereRef('asset.stackId', '=', 'stack.id')
                .where('asset.deletedAt', 'is', null)).as('assets'))
                .execute();
            const uniqueIds = new Set(assetIds);
            for (const stack of stacks) {
                if (stack.assets && stack.assets.length > 0) {
                    for (const asset of stack.assets) {
                        uniqueIds.add(asset.id);
                    }
                }
            }
            if (stacks.length > 0) {
                await tx
                    .deleteFrom('stack')
                    .where('id', 'in', stacks.map((stack) => stack.id))
                    .execute();
            }
            const newRecord = await tx
                .insertInto('stack')
                .values({ ...entity, primaryAssetId: assetIds[0] })
                .returning('id')
                .executeTakeFirstOrThrow();
            await tx
                .updateTable('asset')
                .set({
                stackId: newRecord.id,
                updatedAt: new Date(),
            })
                .where('id', 'in', [...uniqueIds])
                .execute();
            return tx
                .selectFrom('stack')
                .selectAll('stack')
                .select(withAssets)
                .where('id', '=', newRecord.id)
                .executeTakeFirstOrThrow();
        });
    }
    async delete(id) {
        await this.db.deleteFrom('stack').where('id', '=', (0, database_2.asUuid)(id)).execute();
    }
    async deleteAll(ids) {
        await this.db.deleteFrom('stack').where('id', 'in', ids).execute();
    }
    update(id, entity) {
        return this.db
            .updateTable('stack')
            .set(entity)
            .where('id', '=', (0, database_2.asUuid)(id))
            .returningAll('stack')
            .returning((eb) => withAssets(eb, true))
            .executeTakeFirstOrThrow();
    }
    getById(id) {
        return this.db
            .selectFrom('stack')
            .selectAll()
            .select((eb) => withAssets(eb, true))
            .where('id', '=', (0, database_2.asUuid)(id))
            .executeTakeFirst();
    }
    getForAssetRemoval(assetId) {
        return this.db
            .selectFrom('asset')
            .leftJoin('stack', 'stack.id', 'asset.stackId')
            .select(['stackId as id', 'stack.primaryAssetId'])
            .where('asset.id', '=', assetId)
            .executeTakeFirst();
    }
};
exports.StackRepository = StackRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ ownerId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], StackRepository.prototype, "search", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], StackRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], StackRepository.prototype, "getById", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], StackRepository.prototype, "getForAssetRemoval", null);
exports.StackRepository = StackRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], StackRepository);
//# sourceMappingURL=stack.repository.js.map