"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const dummyBackfillOptions = {
    nowId: decorators_1.DummyValue.UUID,
    beforeUpdateId: decorators_1.DummyValue.UUID,
    afterUpdateId: decorators_1.DummyValue.UUID,
};
const dummyCreateAfterOptions = {
    nowId: decorators_1.DummyValue.UUID,
    userId: decorators_1.DummyValue.UUID,
    afterCreateId: decorators_1.DummyValue.UUID,
};
const dummyQueryOptions = {
    nowId: decorators_1.DummyValue.UUID,
    userId: decorators_1.DummyValue.UUID,
    ack: {
        updateId: decorators_1.DummyValue.UUID,
    },
};
let SyncRepository = class SyncRepository {
    db;
    album;
    albumAsset;
    albumAssetExif;
    albumToAsset;
    albumUser;
    asset;
    assetExif;
    assetFace;
    assetMetadata;
    authUser;
    memory;
    memoryToAsset;
    partner;
    partnerAsset;
    partnerAssetExif;
    partnerStack;
    person;
    stack;
    user;
    userMetadata;
    constructor(db) {
        this.db = db;
        this.album = new AlbumSync(this.db);
        this.albumAsset = new AlbumAssetSync(this.db);
        this.albumAssetExif = new AlbumAssetExifSync(this.db);
        this.albumToAsset = new AlbumToAssetSync(this.db);
        this.albumUser = new AlbumUserSync(this.db);
        this.asset = new AssetSync(this.db);
        this.assetExif = new AssetExifSync(this.db);
        this.assetFace = new AssetFaceSync(this.db);
        this.assetMetadata = new AssetMetadataSync(this.db);
        this.authUser = new AuthUserSync(this.db);
        this.memory = new MemorySync(this.db);
        this.memoryToAsset = new MemoryToAssetSync(this.db);
        this.partner = new PartnerSync(this.db);
        this.partnerAsset = new PartnerAssetsSync(this.db);
        this.partnerAssetExif = new PartnerAssetExifsSync(this.db);
        this.partnerStack = new PartnerStackSync(this.db);
        this.person = new PersonSync(this.db);
        this.stack = new StackSync(this.db);
        this.user = new UserSync(this.db);
        this.userMetadata = new UserMetadataSync(this.db);
    }
};
exports.SyncRepository = SyncRepository;
exports.SyncRepository = SyncRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SyncRepository);
class BaseSync {
    db;
    constructor(db) {
        this.db = db;
    }
    backfillQuery(t, { nowId, beforeUpdateId, afterUpdateId }) {
        const { table, ref } = this.db.dynamic;
        const updateIdRef = ref(`${t}.updateId`);
        return this.db
            .selectFrom(table(t).as(t))
            .where(updateIdRef, '<', nowId)
            .where(updateIdRef, '<=', beforeUpdateId)
            .$if(!!afterUpdateId, (qb) => qb.where(updateIdRef, '>=', afterUpdateId))
            .orderBy(updateIdRef, 'asc');
    }
    auditQuery(t, { nowId, ack }) {
        const { table, ref } = this.db.dynamic;
        const idRef = ref(`${t}.id`);
        return this.db
            .selectFrom(table(t).as(t))
            .where(idRef, '<', nowId)
            .$if(!!ack, (qb) => qb.where(idRef, '>', ack.updateId))
            .orderBy(idRef, 'asc');
    }
    auditCleanup(t, days) {
        const { table, ref } = this.db.dynamic;
        return this.db
            .deleteFrom(table(t).as(t))
            .where(ref(`${t}.deletedAt`), '<', kysely_1.sql.raw(`now() - interval '${days} days'`))
            .execute();
    }
    upsertQuery(t, { nowId, ack }) {
        const { table, ref } = this.db.dynamic;
        const updateIdRef = ref(`${t}.updateId`);
        return this.db
            .selectFrom(table(t).as(t))
            .where(updateIdRef, '<', nowId)
            .$if(!!ack, (qb) => qb.where(updateIdRef, '>', ack.updateId))
            .orderBy(updateIdRef, 'asc');
    }
}
class AlbumSync extends BaseSync {
    getCreatedAfter({ nowId, userId, afterCreateId }) {
        return this.db
            .selectFrom('album_user')
            .select(['albumsId as id', 'createId'])
            .where('usersId', '=', userId)
            .$if(!!afterCreateId, (qb) => qb.where('createId', '>=', afterCreateId))
            .where('createId', '<', nowId)
            .orderBy('createId', 'asc')
            .execute();
    }
    getDeletes(options) {
        return this.auditQuery('album_audit', options)
            .select(['id', 'albumId'])
            .where('userId', '=', options.userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('album_audit', daysAgo);
    }
    getUpserts(options) {
        const userId = options.userId;
        return this.upsertQuery('album', options)
            .distinctOn(['album.id', 'album.updateId'])
            .leftJoin('album_user as album_users', 'album.id', 'album_users.albumsId')
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('album_users.usersId', '=', userId)]))
            .select([
            'album.id',
            'album.ownerId',
            'album.albumName as name',
            'album.description',
            'album.createdAt',
            'album.updatedAt',
            'album.albumThumbnailAssetId as thumbnailAssetId',
            'album.isActivityEnabled',
            'album.order',
            'album.updateId',
        ])
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyCreateAfterOptions] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumSync.prototype, "getCreatedAfter", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumSync.prototype, "getUpserts", null);
class AlbumAssetSync extends BaseSync {
    getBackfill(options, albumId) {
        return this.backfillQuery('album_asset', options)
            .innerJoin('asset', 'asset.id', 'album_asset.assetsId')
            .select(database_1.columns.syncAsset)
            .select('album_asset.updateId')
            .where('album_asset.albumsId', '=', albumId)
            .stream();
    }
    getUpdates(options, albumToAssetAck) {
        const userId = options.userId;
        return this.upsertQuery('asset', options)
            .innerJoin('album_asset', 'album_asset.assetsId', 'asset.id')
            .select(database_1.columns.syncAsset)
            .select('asset.updateId')
            .where('album_asset.updateId', '<=', albumToAssetAck.updateId)
            .innerJoin('album', 'album.id', 'album_asset.albumsId')
            .leftJoin('album_user', 'album_user.albumsId', 'album_asset.albumsId')
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('album_user.usersId', '=', userId)]))
            .stream();
    }
    getCreates(options) {
        const userId = options.userId;
        return this.upsertQuery('album_asset', options)
            .select('album_asset.updateId')
            .innerJoin('asset', 'asset.id', 'album_asset.assetsId')
            .select(database_1.columns.syncAsset)
            .innerJoin('album', 'album.id', 'album_asset.albumsId')
            .leftJoin('album_user', 'album_user.albumsId', 'album_asset.albumsId')
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('album_user.usersId', '=', userId)]))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyBackfillOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], AlbumAssetSync.prototype, "getBackfill", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions, { updateId: decorators_1.DummyValue.UUID }], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], AlbumAssetSync.prototype, "getUpdates", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumAssetSync.prototype, "getCreates", null);
class AlbumAssetExifSync extends BaseSync {
    getBackfill(options, albumId) {
        return this.backfillQuery('album_asset', options)
            .innerJoin('asset_exif', 'asset_exif.assetId', 'album_asset.assetsId')
            .select(database_1.columns.syncAssetExif)
            .select('album_asset.updateId')
            .where('album_asset.albumsId', '=', albumId)
            .stream();
    }
    getUpdates(options, albumToAssetAck) {
        const userId = options.userId;
        return this.upsertQuery('asset_exif', options)
            .innerJoin('album_asset', 'album_asset.assetsId', 'asset_exif.assetId')
            .select(database_1.columns.syncAssetExif)
            .select('asset_exif.updateId')
            .where('album_asset.updateId', '<=', albumToAssetAck.updateId)
            .innerJoin('album', 'album.id', 'album_asset.albumsId')
            .leftJoin('album_user', 'album_user.albumsId', 'album_asset.albumsId')
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('album_user.usersId', '=', userId)]))
            .stream();
    }
    getCreates(options) {
        const userId = options.userId;
        return this.upsertQuery('album_asset', options)
            .select('album_asset.updateId')
            .innerJoin('asset_exif', 'asset_exif.assetId', 'album_asset.assetsId')
            .select(database_1.columns.syncAssetExif)
            .innerJoin('album', 'album.id', 'album_asset.albumsId')
            .leftJoin('album_user', 'album_user.albumsId', 'album_asset.albumsId')
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('album_user.usersId', '=', userId)]))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyBackfillOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], AlbumAssetExifSync.prototype, "getBackfill", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions, { updateId: decorators_1.DummyValue.UUID }], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], AlbumAssetExifSync.prototype, "getUpdates", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumAssetExifSync.prototype, "getCreates", null);
class AlbumToAssetSync extends BaseSync {
    getBackfill(options, albumId) {
        return this.backfillQuery('album_asset', options)
            .select(['album_asset.assetsId as assetId', 'album_asset.albumsId as albumId', 'album_asset.updateId'])
            .where('album_asset.albumsId', '=', albumId)
            .stream();
    }
    getDeletes(options) {
        const userId = options.userId;
        return this.auditQuery('album_asset_audit', options)
            .select(['id', 'assetId', 'albumId'])
            .where((eb) => eb('albumId', 'in', eb
            .selectFrom('album')
            .select(['id'])
            .where('ownerId', '=', userId)
            .union((eb) => eb.parens(eb
            .selectFrom('album_user')
            .select(['album_user.albumsId as id'])
            .where('album_user.usersId', '=', userId)))))
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('album_asset_audit', daysAgo);
    }
    getUpserts(options) {
        const userId = options.userId;
        return this.upsertQuery('album_asset', options)
            .select(['album_asset.assetsId as assetId', 'album_asset.albumsId as albumId', 'album_asset.updateId'])
            .innerJoin('album', 'album.id', 'album_asset.albumsId')
            .leftJoin('album_user', 'album_user.albumsId', 'album_asset.albumsId')
            .where((eb) => eb.or([eb('album.ownerId', '=', userId), eb('album_user.usersId', '=', userId)]))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyBackfillOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], AlbumToAssetSync.prototype, "getBackfill", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumToAssetSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumToAssetSync.prototype, "getUpserts", null);
class AlbumUserSync extends BaseSync {
    getBackfill(options, albumId) {
        return this.backfillQuery('album_user', options)
            .select(database_1.columns.syncAlbumUser)
            .select('album_user.updateId')
            .where('albumsId', '=', albumId)
            .stream();
    }
    getDeletes(options) {
        const userId = options.userId;
        return this.auditQuery('album_user_audit', options)
            .select(['id', 'userId', 'albumId'])
            .where((eb) => eb('albumId', 'in', eb
            .selectFrom('album')
            .select(['id'])
            .where('ownerId', '=', userId)
            .union((eb) => eb.parens(eb
            .selectFrom('album_user')
            .select(['album_user.albumsId as id'])
            .where('album_user.usersId', '=', userId)))))
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('album_user_audit', daysAgo);
    }
    getUpserts(options) {
        const userId = options.userId;
        return this.upsertQuery('album_user', options)
            .select(database_1.columns.syncAlbumUser)
            .select('album_user.updateId')
            .where((eb) => eb('album_user.albumsId', 'in', eb
            .selectFrom('album')
            .select(['id'])
            .where('ownerId', '=', userId)
            .union((eb) => eb.parens(eb
            .selectFrom('album_user as albumUsers')
            .select(['albumUsers.albumsId as id'])
            .where('albumUsers.usersId', '=', userId)))))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyBackfillOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], AlbumUserSync.prototype, "getBackfill", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumUserSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumUserSync.prototype, "getUpserts", null);
class AssetSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('asset_audit', options)
            .select(['id', 'assetId'])
            .where('ownerId', '=', options.userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('asset_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('asset', options)
            .select(database_1.columns.syncAsset)
            .select('asset.updateId')
            .where('ownerId', '=', options.userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AssetSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AssetSync.prototype, "getUpserts", null);
class AuthUserSync extends BaseSync {
    getUpserts(options) {
        return this.upsertQuery('user', options)
            .select(database_1.columns.syncUser)
            .select(['isAdmin', 'pinCode', 'oauthId', 'storageLabel', 'quotaSizeInBytes', 'quotaUsageInBytes'])
            .where('id', '=', options.userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AuthUserSync.prototype, "getUpserts", null);
class PersonSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('person_audit', options)
            .select(['id', 'personId'])
            .where('ownerId', '=', options.userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('person_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('person', options)
            .select([
            'id',
            'createdAt',
            'updatedAt',
            'ownerId',
            'name',
            'birthDate',
            'isHidden',
            'isFavorite',
            'color',
            'updateId',
            'faceAssetId',
        ])
            .where('ownerId', '=', options.userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PersonSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PersonSync.prototype, "getUpserts", null);
class AssetFaceSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('asset_face_audit', options)
            .select(['asset_face_audit.id', 'assetFaceId'])
            .leftJoin('asset', 'asset.id', 'asset_face_audit.assetId')
            .where('asset.ownerId', '=', options.userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('asset_face_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('asset_face', options)
            .select([
            'asset_face.id',
            'assetId',
            'personId',
            'imageWidth',
            'imageHeight',
            'boundingBoxX1',
            'boundingBoxY1',
            'boundingBoxX2',
            'boundingBoxY2',
            'sourceType',
            'asset_face.updateId',
        ])
            .leftJoin('asset', 'asset.id', 'asset_face.assetId')
            .where('asset.ownerId', '=', options.userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AssetFaceSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AssetFaceSync.prototype, "getUpserts", null);
class AssetExifSync extends BaseSync {
    getUpserts(options) {
        return this.upsertQuery('asset_exif', options)
            .select(database_1.columns.syncAssetExif)
            .select('asset_exif.updateId')
            .where('assetId', 'in', (eb) => eb.selectFrom('asset').select('id').where('ownerId', '=', options.userId))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AssetExifSync.prototype, "getUpserts", null);
class MemorySync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('memory_audit', options)
            .select(['id', 'memoryId'])
            .where('userId', '=', options.userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('memory_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('memory', options)
            .select([
            'id',
            'createdAt',
            'updatedAt',
            'deletedAt',
            'ownerId',
            'type',
            'data',
            'isSaved',
            'memoryAt',
            'seenAt',
            'showAt',
            'hideAt',
        ])
            .select('updateId')
            .where('ownerId', '=', options.userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], MemorySync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], MemorySync.prototype, "getUpserts", null);
class MemoryToAssetSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('memory_asset_audit', options)
            .select(['id', 'memoryId', 'assetId'])
            .where('memoryId', 'in', (eb) => eb.selectFrom('memory').select('id').where('ownerId', '=', options.userId))
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('memory_asset_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('memory_asset', options)
            .select(['memoriesId as memoryId', 'assetsId as assetId'])
            .select('updateId')
            .where('memoriesId', 'in', (eb) => eb.selectFrom('memory').select('id').where('ownerId', '=', options.userId))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], MemoryToAssetSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], MemoryToAssetSync.prototype, "getUpserts", null);
class PartnerSync extends BaseSync {
    getCreatedAfter({ nowId, userId, afterCreateId }) {
        return this.db
            .selectFrom('partner')
            .select(['sharedById', 'createId'])
            .where('sharedWithId', '=', userId)
            .$if(!!afterCreateId, (qb) => qb.where('createId', '>=', afterCreateId))
            .where('createId', '<', nowId)
            .orderBy('partner.createId', 'asc')
            .execute();
    }
    getDeletes(options) {
        const userId = options.userId;
        return this.auditQuery('partner_audit', options)
            .select(['id', 'sharedById', 'sharedWithId'])
            .where((eb) => eb.or([eb('sharedById', '=', userId), eb('sharedWithId', '=', userId)]))
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('partner_audit', daysAgo);
    }
    getUpserts(options) {
        const userId = options.userId;
        return this.upsertQuery('partner', options)
            .select(['sharedById', 'sharedWithId', 'inTimeline', 'updateId'])
            .where((eb) => eb.or([eb('sharedById', '=', userId), eb('sharedWithId', '=', userId)]))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyCreateAfterOptions] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerSync.prototype, "getCreatedAfter", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerSync.prototype, "getUpserts", null);
class PartnerAssetsSync extends BaseSync {
    getBackfill(options, partnerId) {
        return this.backfillQuery('asset', options)
            .select(database_1.columns.syncAsset)
            .select('asset.updateId')
            .where('ownerId', '=', partnerId)
            .stream();
    }
    getDeletes(options) {
        return this.auditQuery('asset_audit', options)
            .select(['id', 'assetId'])
            .where('ownerId', 'in', (eb) => eb.selectFrom('partner').select(['sharedById']).where('sharedWithId', '=', options.userId))
            .stream();
    }
    getUpserts(options) {
        return this.upsertQuery('asset', options)
            .select(database_1.columns.syncAsset)
            .select('asset.updateId')
            .where('ownerId', 'in', (eb) => eb.selectFrom('partner').select(['sharedById']).where('sharedWithId', '=', options.userId))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyBackfillOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], PartnerAssetsSync.prototype, "getBackfill", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerAssetsSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerAssetsSync.prototype, "getUpserts", null);
class PartnerAssetExifsSync extends BaseSync {
    getBackfill(options, partnerId) {
        return this.backfillQuery('asset_exif', options)
            .select(database_1.columns.syncAssetExif)
            .select('asset_exif.updateId')
            .innerJoin('asset', 'asset.id', 'asset_exif.assetId')
            .where('asset.ownerId', '=', partnerId)
            .stream();
    }
    getUpserts(options) {
        return this.upsertQuery('asset_exif', options)
            .select(database_1.columns.syncAssetExif)
            .select('asset_exif.updateId')
            .where('assetId', 'in', (eb) => eb
            .selectFrom('asset')
            .select('id')
            .where('ownerId', 'in', (eb) => eb.selectFrom('partner').select(['sharedById']).where('sharedWithId', '=', options.userId)))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyBackfillOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], PartnerAssetExifsSync.prototype, "getBackfill", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerAssetExifsSync.prototype, "getUpserts", null);
class StackSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('stack_audit', options)
            .select(['id', 'stackId'])
            .where('userId', '=', options.userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('stack_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('stack', options)
            .select(database_1.columns.syncStack)
            .select('updateId')
            .where('ownerId', '=', options.userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], StackSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], StackSync.prototype, "getUpserts", null);
class PartnerStackSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('stack_audit', options)
            .select(['id', 'stackId'])
            .where('userId', 'in', (eb) => eb.selectFrom('partner').select(['sharedById']).where('sharedWithId', '=', options.userId))
            .stream();
    }
    getBackfill(options, partnerId) {
        return this.backfillQuery('stack', options)
            .select(database_1.columns.syncStack)
            .select('updateId')
            .where('ownerId', '=', partnerId)
            .stream();
    }
    getUpserts(options) {
        return this.upsertQuery('stack', options)
            .select(database_1.columns.syncStack)
            .select('updateId')
            .where('ownerId', 'in', (eb) => eb.selectFrom('partner').select(['sharedById']).where('sharedWithId', '=', options.userId))
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerStackSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyBackfillOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], PartnerStackSync.prototype, "getBackfill", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], PartnerStackSync.prototype, "getUpserts", null);
class UserSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('user_audit', options).select(['id', 'userId']).stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('user_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('user', options).select(database_1.columns.syncUser).stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], UserSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], UserSync.prototype, "getUpserts", null);
class UserMetadataSync extends BaseSync {
    getDeletes(options) {
        return this.auditQuery('user_metadata_audit', options)
            .select(['id', 'userId', 'key'])
            .where('userId', '=', options.userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('user_metadata_audit', daysAgo);
    }
    getUpserts(options) {
        return this.upsertQuery('user_metadata', options)
            .select(['userId', 'key', 'value', 'updateId'])
            .where('userId', '=', options.userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], UserMetadataSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], UserMetadataSync.prototype, "getUpserts", null);
class AssetMetadataSync extends BaseSync {
    getDeletes(options, userId) {
        return this.auditQuery('asset_metadata_audit', options)
            .select(['asset_metadata_audit.id', 'assetId', 'key'])
            .leftJoin('asset', 'asset.id', 'asset_metadata_audit.assetId')
            .where('asset.ownerId', '=', userId)
            .stream();
    }
    cleanupAuditTable(daysAgo) {
        return this.auditCleanup('asset_metadata_audit', daysAgo);
    }
    getUpserts(options, userId) {
        return this.upsertQuery('asset_metadata', options)
            .select(['assetId', 'key', 'value', 'asset_metadata.updateId'])
            .innerJoin('asset', 'asset.id', 'asset_metadata.assetId')
            .where('asset.ownerId', '=', userId)
            .stream();
    }
}
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], AssetMetadataSync.prototype, "getDeletes", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [dummyQueryOptions, decorators_1.DummyValue.UUID], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], AssetMetadataSync.prototype, "getUpserts", null);
//# sourceMappingURL=sync.repository.js.map