import { Kysely } from 'kysely';
import { AssetVisibility } from 'src/enum';
import { DB } from 'src/schema';
export declare class ViewRepository {
    private db;
    constructor(db: Kysely<DB>);
    getUniqueOriginalPaths(userId: string): Promise<string[]>;
    getAssetsByOriginalPath(userId: string, partialPath: string): Promise<{
        id: string;
        type: import("src/enum").AssetType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        status: import("src/enum").AssetStatus;
        updateId: string;
        ownerId: string;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        isFavorite: boolean;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        stackId: string | null;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("../database").Exif | null;
    }[]>;
}
