"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asset_face_audit = exports.asset_metadata_audit = exports.user_metadata_audit = exports.person_delete_audit = exports.stack_delete_audit = exports.memory_asset_delete_audit = exports.memory_delete_audit = exports.album_user_delete_audit = exports.album_asset_delete_audit = exports.album_delete_audit = exports.asset_delete_audit = exports.partner_delete_audit = exports.user_delete_audit = exports.ll_to_earth_public = exports.f_unaccent = exports.f_concat_ws = exports.updated_at = exports.album_user_after_insert = exports.immich_uuid_v7 = void 0;
const sql_tools_1 = require("../sql-tools");
exports.immich_uuid_v7 = (0, sql_tools_1.registerFunction)({
    name: 'immich_uuid_v7',
    arguments: ['p_timestamp timestamp with time zone default clock_timestamp()'],
    returnType: 'uuid',
    language: 'SQL',
    behavior: 'volatile',
    body: `
    SELECT encode(
      set_bit(
        set_bit(
          overlay(uuid_send(gen_random_uuid())
                  placing substring(int8send(floor(extract(epoch from p_timestamp) * 1000)::bigint) from 3)
                  from 1 for 6
          ),
          52, 1
        ),
        53, 1
      ),
      'hex')::uuid;
`,
});
exports.album_user_after_insert = (0, sql_tools_1.registerFunction)({
    name: 'album_user_after_insert',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      UPDATE album SET "updatedAt" = clock_timestamp(), "updateId" = immich_uuid_v7(clock_timestamp())
      WHERE "id" IN (SELECT DISTINCT "albumsId" FROM inserted_rows);
      RETURN NULL;
    END`,
});
exports.updated_at = (0, sql_tools_1.registerFunction)({
    name: 'updated_at',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    DECLARE
        clock_timestamp TIMESTAMP := clock_timestamp();
    BEGIN
        new."updatedAt" = clock_timestamp;
        new."updateId" = immich_uuid_v7(clock_timestamp);
        return new;
    END;`,
});
exports.f_concat_ws = (0, sql_tools_1.registerFunction)({
    name: 'f_concat_ws',
    arguments: ['text', 'text[]'],
    returnType: 'text',
    language: 'SQL',
    parallel: 'safe',
    behavior: 'immutable',
    body: `SELECT array_to_string($2, $1)`,
});
exports.f_unaccent = (0, sql_tools_1.registerFunction)({
    name: 'f_unaccent',
    arguments: ['text'],
    returnType: 'text',
    language: 'SQL',
    parallel: 'safe',
    strict: true,
    behavior: 'immutable',
    return: `unaccent('unaccent', $1)`,
});
exports.ll_to_earth_public = (0, sql_tools_1.registerFunction)({
    name: 'll_to_earth_public',
    arguments: ['latitude double precision', 'longitude double precision'],
    returnType: 'public.earth',
    language: 'SQL',
    parallel: 'safe',
    strict: true,
    behavior: 'immutable',
    body: `SELECT public.cube(public.cube(public.cube(public.earth()*cos(radians(latitude))*cos(radians(longitude))),public.earth()*cos(radians(latitude))*sin(radians(longitude))),public.earth()*sin(radians(latitude)))::public.earth`,
});
exports.user_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'user_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO user_audit ("userId")
      SELECT "id"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.partner_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'partner_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO partner_audit ("sharedById", "sharedWithId")
      SELECT "sharedById", "sharedWithId"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.asset_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'asset_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO asset_audit ("assetId", "ownerId")
      SELECT "id", "ownerId"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.album_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'album_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO album_audit ("albumId", "userId")
      SELECT "id", "ownerId"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.album_asset_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'album_asset_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO album_asset_audit ("albumId", "assetId")
      SELECT "albumsId", "assetsId" FROM OLD
      WHERE "albumsId" IN (SELECT "id" FROM album WHERE "id" IN (SELECT "albumsId" FROM OLD));
      RETURN NULL;
    END`,
});
exports.album_user_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'album_user_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO album_audit ("albumId", "userId")
      SELECT "albumsId", "usersId"
      FROM OLD;

      IF pg_trigger_depth() = 1 THEN
        INSERT INTO album_user_audit ("albumId", "userId")
        SELECT "albumsId", "usersId"
        FROM OLD;
      END IF;

      RETURN NULL;
    END`,
});
exports.memory_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'memory_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO memory_audit ("memoryId", "userId")
      SELECT "id", "ownerId"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.memory_asset_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'memory_asset_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO memory_asset_audit ("memoryId", "assetId")
      SELECT "memoriesId", "assetsId" FROM OLD
      WHERE "memoriesId" IN (SELECT "id" FROM memory WHERE "id" IN (SELECT "memoriesId" FROM OLD));
      RETURN NULL;
    END`,
});
exports.stack_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'stack_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO stack_audit ("stackId", "userId")
      SELECT "id", "ownerId"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.person_delete_audit = (0, sql_tools_1.registerFunction)({
    name: 'person_delete_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO person_audit ("personId", "ownerId")
      SELECT "id", "ownerId"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.user_metadata_audit = (0, sql_tools_1.registerFunction)({
    name: 'user_metadata_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO user_metadata_audit ("userId", "key")
      SELECT "userId", "key"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.asset_metadata_audit = (0, sql_tools_1.registerFunction)({
    name: 'asset_metadata_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO asset_metadata_audit ("assetId", "key")
      SELECT "assetId", "key"
      FROM OLD;
      RETURN NULL;
    END`,
});
exports.asset_face_audit = (0, sql_tools_1.registerFunction)({
    name: 'asset_face_audit',
    returnType: 'TRIGGER',
    language: 'PLPGSQL',
    body: `
    BEGIN
      INSERT INTO asset_face_audit ("assetFaceId", "assetId")
      SELECT "id", "assetId"
      FROM OLD;
      RETURN NULL;
    END`,
});
//# sourceMappingURL=functions.js.map