"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `DELETE FROM activity AS a
          WHERE a."assetId" IS NOT NULL
          AND NOT EXISTS (
            SELECT 1
              FROM albums_assets_assets AS aaa
              WHERE a."albumId" = aaa."albumsId"
              AND a."assetId" = aaa."assetsId"
        );`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "activity" ADD CONSTRAINT "fk_activity_album_asset_composite" FOREIGN KEY ("albumId", "assetId") REFERENCES "albums_assets_assets" ("albumsId", "assetsId") ON UPDATE NO ACTION ON DELETE CASCADE;`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "IDX_86102d85cfa7f196073aebff68" ON "activity" ("albumId", "assetId")`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DROP INDEX "IDX_86102d85cfa7f196073aebff68";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "activity" DROP CONSTRAINT "fk_activity_album_asset_composite";`.execute(db);
}
//# sourceMappingURL=1752161055254-AddActivityAssetFk.js.map