"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumUserTable = void 0;
const decorators_1 = require("../../decorators");
const enum_1 = require("../../enum");
const functions_1 = require("../functions");
const album_table_1 = require("./album.table");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
let AlbumUserTable = class AlbumUserTable {
    albumsId;
    usersId;
    role;
    createId;
    createdAt;
    updateId;
    updatedAt;
};
exports.AlbumUserTable = AlbumUserTable;
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => album_table_1.AlbumTable, {
        onDelete: 'CASCADE',
        onUpdate: 'CASCADE',
        nullable: false,
        primary: true,
    }),
    __metadata("design:type", String)
], AlbumUserTable.prototype, "albumsId", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, {
        onDelete: 'CASCADE',
        onUpdate: 'CASCADE',
        nullable: false,
        primary: true,
    }),
    __metadata("design:type", String)
], AlbumUserTable.prototype, "usersId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'character varying', default: enum_1.AlbumUserRole.Editor }),
    __metadata("design:type", Object)
], AlbumUserTable.prototype, "role", void 0);
__decorate([
    (0, decorators_1.CreateIdColumn)({ index: true }),
    __metadata("design:type", Object)
], AlbumUserTable.prototype, "createId", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Object)
], AlbumUserTable.prototype, "createdAt", void 0);
__decorate([
    (0, decorators_1.UpdateIdColumn)({ index: true }),
    __metadata("design:type", Object)
], AlbumUserTable.prototype, "updateId", void 0);
__decorate([
    (0, sql_tools_1.UpdateDateColumn)(),
    __metadata("design:type", Object)
], AlbumUserTable.prototype, "updatedAt", void 0);
exports.AlbumUserTable = AlbumUserTable = __decorate([
    (0, sql_tools_1.Table)({ name: 'album_user' }),
    (0, decorators_1.UpdatedAtTrigger)('album_user_updatedAt'),
    (0, sql_tools_1.AfterInsertTrigger)({
        name: 'album_user_after_insert',
        scope: 'statement',
        referencingNewTableAs: 'inserted_rows',
        function: functions_1.album_user_after_insert,
    }),
    (0, sql_tools_1.AfterDeleteTrigger)({
        scope: 'statement',
        function: functions_1.album_user_delete_audit,
        referencingOldTableAs: 'old',
        when: 'pg_trigger_depth() <= 1',
    })
], AlbumUserTable);
//# sourceMappingURL=album-user.table.js.map