import { AssetStatus, AssetType, AssetVisibility } from 'src/enum';
import { Generated, Timestamp } from 'src/sql-tools';
export declare class AssetTable {
    id: Generated<string>;
    deviceAssetId: string;
    ownerId: string;
    deviceId: string;
    type: AssetType;
    originalPath: string;
    fileCreatedAt: Timestamp;
    fileModifiedAt: Timestamp;
    isFavorite: Generated<boolean>;
    duration: string | null;
    encodedVideoPath: string | null;
    checksum: Buffer;
    livePhotoVideoId: string | null;
    updatedAt: Generated<Timestamp>;
    createdAt: Generated<Timestamp>;
    originalFileName: string;
    sidecarPath: string | null;
    thumbhash: Buffer | null;
    isOffline: Generated<boolean>;
    libraryId: string | null;
    isExternal: Generated<boolean>;
    deletedAt: Timestamp | null;
    localDateTime: Timestamp;
    stackId: string | null;
    duplicateId: string | null;
    status: Generated<AssetStatus>;
    updateId: Generated<string>;
    visibility: Generated<AssetVisibility>;
}
