import { NextFunction, Request, Response } from 'express';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { AuthService } from 'src/services/auth.service';
import { JobService } from 'src/services/job.service';
import { SharedLinkService } from 'src/services/shared-link.service';
import { VersionService } from 'src/services/version.service';
export declare class ApiService {
    private authService;
    private jobService;
    private sharedLinkService;
    private versionService;
    private configRepository;
    private logger;
    constructor(authService: AuthService, jobService: JobService, sharedLinkService: SharedLinkService, versionService: VersionService, configRepository: ConfigRepository, logger: LoggingRepository);
    onVersionCheck(): Promise<void>;
    ssr(excludePaths: string[]): (request: Request, res: Response, next: NextFunction) => Promise<void>;
}
