import { AssetResponseDto, SanitizedAssetResponseDto } from 'src/dtos/asset-response.dto';
import { AssetBulkDeleteDto, AssetBulkUpdateDto, AssetJobsDto, AssetMetadataResponseDto, AssetMetadataUpsertDto, AssetStatsDto, UpdateAssetDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetMetadataKey, JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class AssetService extends BaseService {
    getStatistics(auth: AuthDto, dto: AssetStatsDto): Promise<import("src/dtos/asset.dto").AssetStatsResponseDto>;
    getRandom(auth: AuthDto, count: number): Promise<AssetResponseDto[]>;
    getUserAssetsByDeviceId(auth: AuthDto, deviceId: string): Promise<string[]>;
    get(auth: AuthDto, id: string): Promise<AssetResponseDto | SanitizedAssetResponseDto>;
    update(auth: AuthDto, id: string, dto: UpdateAssetDto): Promise<AssetResponseDto>;
    updateAll(auth: AuthDto, dto: AssetBulkUpdateDto): Promise<void>;
    handleAssetDeletionCheck(): Promise<JobStatus>;
    handleAssetDeletion(job: JobOf<JobName.AssetDelete>): Promise<JobStatus>;
    deleteAll(auth: AuthDto, dto: AssetBulkDeleteDto): Promise<void>;
    getMetadata(auth: AuthDto, id: string): Promise<AssetMetadataResponseDto[]>;
    upsertMetadata(auth: AuthDto, id: string, dto: AssetMetadataUpsertDto): Promise<AssetMetadataResponseDto[]>;
    getMetadataByKey(auth: AuthDto, id: string, key: AssetMetadataKey): Promise<AssetMetadataResponseDto>;
    deleteMetadataByKey(auth: AuthDto, id: string, key: AssetMetadataKey): Promise<void>;
    run(auth: AuthDto, dto: AssetJobsDto): Promise<void>;
    private findOrFail;
    private updateExif;
}
