import { IncomingHttpHeaders } from 'node:http';
import { AuthDto, AuthStatusResponseDto, ChangePasswordDto, LoginCredentialDto, LogoutResponseDto, OAuthCallbackDto, OAuthConfigDto, PinCodeChangeDto, PinCodeResetDto, PinCodeSetupDto, SessionUnlockDto, SignUpDto } from 'src/dtos/auth.dto';
import { UserAdminResponseDto } from 'src/dtos/user.dto';
import { AuthType, Permission } from 'src/enum';
import { BaseService } from 'src/services/base.service';
export interface LoginDetails {
    isSecure: boolean;
    clientIp: string;
    deviceType: string;
    deviceOS: string;
}
export type ValidateRequest = {
    headers: IncomingHttpHeaders;
    queryParams: Record<string, string>;
    metadata: {
        sharedLinkRoute: boolean;
        adminRoute: boolean;
        permission?: Permission | false;
        uri: string;
    };
};
export declare class AuthService extends BaseService {
    login(dto: LoginCredentialDto, details: LoginDetails): Promise<import("src/dtos/auth.dto").LoginResponseDto>;
    logout(auth: AuthDto, authType: AuthType): Promise<LogoutResponseDto>;
    changePassword(auth: AuthDto, dto: ChangePasswordDto): Promise<UserAdminResponseDto>;
    setupPinCode(auth: AuthDto, { pinCode }: PinCodeSetupDto): Promise<void>;
    resetPinCode(auth: AuthDto, dto: PinCodeResetDto): Promise<void>;
    changePinCode(auth: AuthDto, dto: PinCodeChangeDto): Promise<void>;
    private validatePinCode;
    adminSignUp(dto: SignUpDto): Promise<UserAdminResponseDto>;
    authenticate({ headers, queryParams, metadata }: ValidateRequest): Promise<AuthDto>;
    private validate;
    getMobileRedirect(url: string): string;
    authorize(dto: OAuthConfigDto): Promise<{
        url: string;
        state: string;
        codeVerifier: string | null;
    }>;
    callback(dto: OAuthCallbackDto, headers: IncomingHttpHeaders, loginDetails: LoginDetails): Promise<import("src/dtos/auth.dto").LoginResponseDto>;
    private syncProfilePicture;
    link(auth: AuthDto, dto: OAuthCallbackDto, headers: IncomingHttpHeaders): Promise<UserAdminResponseDto>;
    unlink(auth: AuthDto): Promise<UserAdminResponseDto>;
    private getLogoutEndpoint;
    private getBearerToken;
    private getCookieToken;
    private getCookieOauthState;
    private getCookieCodeVerifier;
    validateSharedLinkKey(key: string | string[]): Promise<AuthDto>;
    validateSharedLinkSlug(slug: string | string[]): Promise<AuthDto>;
    private isValidSharedLink;
    private validateApiKey;
    private validateSecret;
    private validateSession;
    unlockSession(auth: AuthDto, dto: SessionUnlockDto): Promise<void>;
    lockSession(auth: AuthDto): Promise<void>;
    private createLoginResponse;
    private getClaim;
    private resolveRedirectUri;
    getAuthStatus(auth: AuthDto): Promise<AuthStatusResponseDto>;
}
