"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseService = exports.BASE_SERVICE_DEPENDENCIES = void 0;
const common_1 = require("@nestjs/common");
const sanitize_filename_1 = __importDefault(require("sanitize-filename"));
const constants_1 = require("../constants");
const storage_core_1 = require("../cores/storage.core");
const access_repository_1 = require("../repositories/access.repository");
const activity_repository_1 = require("../repositories/activity.repository");
const album_user_repository_1 = require("../repositories/album-user.repository");
const album_repository_1 = require("../repositories/album.repository");
const api_key_repository_1 = require("../repositories/api-key.repository");
const asset_job_repository_1 = require("../repositories/asset-job.repository");
const asset_repository_1 = require("../repositories/asset.repository");
const audit_repository_1 = require("../repositories/audit.repository");
const config_repository_1 = require("../repositories/config.repository");
const cron_repository_1 = require("../repositories/cron.repository");
const crypto_repository_1 = require("../repositories/crypto.repository");
const database_repository_1 = require("../repositories/database.repository");
const download_repository_1 = require("../repositories/download.repository");
const duplicate_repository_1 = require("../repositories/duplicate.repository");
const email_repository_1 = require("../repositories/email.repository");
const event_repository_1 = require("../repositories/event.repository");
const job_repository_1 = require("../repositories/job.repository");
const library_repository_1 = require("../repositories/library.repository");
const logging_repository_1 = require("../repositories/logging.repository");
const machine_learning_repository_1 = require("../repositories/machine-learning.repository");
const map_repository_1 = require("../repositories/map.repository");
const media_repository_1 = require("../repositories/media.repository");
const memory_repository_1 = require("../repositories/memory.repository");
const metadata_repository_1 = require("../repositories/metadata.repository");
const move_repository_1 = require("../repositories/move.repository");
const notification_repository_1 = require("../repositories/notification.repository");
const oauth_repository_1 = require("../repositories/oauth.repository");
const partner_repository_1 = require("../repositories/partner.repository");
const person_repository_1 = require("../repositories/person.repository");
const process_repository_1 = require("../repositories/process.repository");
const search_repository_1 = require("../repositories/search.repository");
const server_info_repository_1 = require("../repositories/server-info.repository");
const session_repository_1 = require("../repositories/session.repository");
const shared_link_repository_1 = require("../repositories/shared-link.repository");
const stack_repository_1 = require("../repositories/stack.repository");
const storage_repository_1 = require("../repositories/storage.repository");
const sync_checkpoint_repository_1 = require("../repositories/sync-checkpoint.repository");
const sync_repository_1 = require("../repositories/sync.repository");
const system_metadata_repository_1 = require("../repositories/system-metadata.repository");
const tag_repository_1 = require("../repositories/tag.repository");
const telemetry_repository_1 = require("../repositories/telemetry.repository");
const trash_repository_1 = require("../repositories/trash.repository");
const user_repository_1 = require("../repositories/user.repository");
const version_history_repository_1 = require("../repositories/version-history.repository");
const view_repository_1 = require("../repositories/view-repository");
const access_1 = require("../utils/access");
const config_1 = require("../utils/config");
exports.BASE_SERVICE_DEPENDENCIES = [
    logging_repository_1.LoggingRepository,
    access_repository_1.AccessRepository,
    activity_repository_1.ActivityRepository,
    album_repository_1.AlbumRepository,
    album_user_repository_1.AlbumUserRepository,
    api_key_repository_1.ApiKeyRepository,
    asset_repository_1.AssetRepository,
    asset_job_repository_1.AssetJobRepository,
    audit_repository_1.AuditRepository,
    config_repository_1.ConfigRepository,
    cron_repository_1.CronRepository,
    crypto_repository_1.CryptoRepository,
    database_repository_1.DatabaseRepository,
    download_repository_1.DownloadRepository,
    duplicate_repository_1.DuplicateRepository,
    email_repository_1.EmailRepository,
    event_repository_1.EventRepository,
    job_repository_1.JobRepository,
    library_repository_1.LibraryRepository,
    machine_learning_repository_1.MachineLearningRepository,
    map_repository_1.MapRepository,
    media_repository_1.MediaRepository,
    memory_repository_1.MemoryRepository,
    metadata_repository_1.MetadataRepository,
    move_repository_1.MoveRepository,
    notification_repository_1.NotificationRepository,
    oauth_repository_1.OAuthRepository,
    partner_repository_1.PartnerRepository,
    person_repository_1.PersonRepository,
    process_repository_1.ProcessRepository,
    search_repository_1.SearchRepository,
    server_info_repository_1.ServerInfoRepository,
    session_repository_1.SessionRepository,
    shared_link_repository_1.SharedLinkRepository,
    stack_repository_1.StackRepository,
    storage_repository_1.StorageRepository,
    sync_repository_1.SyncRepository,
    sync_checkpoint_repository_1.SyncCheckpointRepository,
    system_metadata_repository_1.SystemMetadataRepository,
    tag_repository_1.TagRepository,
    telemetry_repository_1.TelemetryRepository,
    trash_repository_1.TrashRepository,
    user_repository_1.UserRepository,
    version_history_repository_1.VersionHistoryRepository,
    view_repository_1.ViewRepository,
];
let BaseService = class BaseService {
    logger;
    accessRepository;
    activityRepository;
    albumRepository;
    albumUserRepository;
    apiKeyRepository;
    assetRepository;
    assetJobRepository;
    auditRepository;
    configRepository;
    cronRepository;
    cryptoRepository;
    databaseRepository;
    downloadRepository;
    duplicateRepository;
    emailRepository;
    eventRepository;
    jobRepository;
    libraryRepository;
    machineLearningRepository;
    mapRepository;
    mediaRepository;
    memoryRepository;
    metadataRepository;
    moveRepository;
    notificationRepository;
    oauthRepository;
    partnerRepository;
    personRepository;
    processRepository;
    searchRepository;
    serverInfoRepository;
    sessionRepository;
    sharedLinkRepository;
    stackRepository;
    storageRepository;
    syncRepository;
    syncCheckpointRepository;
    systemMetadataRepository;
    tagRepository;
    telemetryRepository;
    trashRepository;
    userRepository;
    versionRepository;
    viewRepository;
    storageCore;
    constructor(logger, accessRepository, activityRepository, albumRepository, albumUserRepository, apiKeyRepository, assetRepository, assetJobRepository, auditRepository, configRepository, cronRepository, cryptoRepository, databaseRepository, downloadRepository, duplicateRepository, emailRepository, eventRepository, jobRepository, libraryRepository, machineLearningRepository, mapRepository, mediaRepository, memoryRepository, metadataRepository, moveRepository, notificationRepository, oauthRepository, partnerRepository, personRepository, processRepository, searchRepository, serverInfoRepository, sessionRepository, sharedLinkRepository, stackRepository, storageRepository, syncRepository, syncCheckpointRepository, systemMetadataRepository, tagRepository, telemetryRepository, trashRepository, userRepository, versionRepository, viewRepository) {
        this.logger = logger;
        this.accessRepository = accessRepository;
        this.activityRepository = activityRepository;
        this.albumRepository = albumRepository;
        this.albumUserRepository = albumUserRepository;
        this.apiKeyRepository = apiKeyRepository;
        this.assetRepository = assetRepository;
        this.assetJobRepository = assetJobRepository;
        this.auditRepository = auditRepository;
        this.configRepository = configRepository;
        this.cronRepository = cronRepository;
        this.cryptoRepository = cryptoRepository;
        this.databaseRepository = databaseRepository;
        this.downloadRepository = downloadRepository;
        this.duplicateRepository = duplicateRepository;
        this.emailRepository = emailRepository;
        this.eventRepository = eventRepository;
        this.jobRepository = jobRepository;
        this.libraryRepository = libraryRepository;
        this.machineLearningRepository = machineLearningRepository;
        this.mapRepository = mapRepository;
        this.mediaRepository = mediaRepository;
        this.memoryRepository = memoryRepository;
        this.metadataRepository = metadataRepository;
        this.moveRepository = moveRepository;
        this.notificationRepository = notificationRepository;
        this.oauthRepository = oauthRepository;
        this.partnerRepository = partnerRepository;
        this.personRepository = personRepository;
        this.processRepository = processRepository;
        this.searchRepository = searchRepository;
        this.serverInfoRepository = serverInfoRepository;
        this.sessionRepository = sessionRepository;
        this.sharedLinkRepository = sharedLinkRepository;
        this.stackRepository = stackRepository;
        this.storageRepository = storageRepository;
        this.syncRepository = syncRepository;
        this.syncCheckpointRepository = syncCheckpointRepository;
        this.systemMetadataRepository = systemMetadataRepository;
        this.tagRepository = tagRepository;
        this.telemetryRepository = telemetryRepository;
        this.trashRepository = trashRepository;
        this.userRepository = userRepository;
        this.versionRepository = versionRepository;
        this.viewRepository = viewRepository;
        this.logger.setContext(this.constructor.name);
        this.storageCore = storage_core_1.StorageCore.create(assetRepository, configRepository, cryptoRepository, moveRepository, personRepository, storageRepository, systemMetadataRepository, this.logger);
    }
    get worker() {
        return this.configRepository.getWorker();
    }
    get configRepos() {
        return {
            configRepo: this.configRepository,
            metadataRepo: this.systemMetadataRepository,
            logger: this.logger,
        };
    }
    getConfig(options) {
        return (0, config_1.getConfig)(this.configRepos, options);
    }
    updateConfig(newConfig) {
        return (0, config_1.updateConfig)(this.configRepos, newConfig);
    }
    requireAccess(request) {
        return (0, access_1.requireAccess)(this.accessRepository, request);
    }
    checkAccess(request) {
        return (0, access_1.checkAccess)(this.accessRepository, request);
    }
    async createUser(dto) {
        const user = await this.userRepository.getByEmail(dto.email);
        if (user) {
            throw new common_1.BadRequestException('User exists');
        }
        if (!dto.isAdmin) {
            const localAdmin = await this.userRepository.getAdmin();
            if (!localAdmin) {
                throw new common_1.BadRequestException('The first registered account must the administrator.');
            }
        }
        const payload = { ...dto };
        if (payload.password) {
            payload.password = await this.cryptoRepository.hashBcrypt(payload.password, constants_1.SALT_ROUNDS);
        }
        if (payload.storageLabel) {
            payload.storageLabel = (0, sanitize_filename_1.default)(payload.storageLabel.replaceAll('.', ''));
        }
        this.telemetryRepository.api.addToGauge(`immich.users.total`, 1);
        return this.userRepository.create(payload);
    }
};
exports.BaseService = BaseService;
exports.BaseService = BaseService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        access_repository_1.AccessRepository,
        activity_repository_1.ActivityRepository,
        album_repository_1.AlbumRepository,
        album_user_repository_1.AlbumUserRepository,
        api_key_repository_1.ApiKeyRepository,
        asset_repository_1.AssetRepository,
        asset_job_repository_1.AssetJobRepository,
        audit_repository_1.AuditRepository,
        config_repository_1.ConfigRepository,
        cron_repository_1.CronRepository,
        crypto_repository_1.CryptoRepository,
        database_repository_1.DatabaseRepository,
        download_repository_1.DownloadRepository,
        duplicate_repository_1.DuplicateRepository,
        email_repository_1.EmailRepository,
        event_repository_1.EventRepository,
        job_repository_1.JobRepository,
        library_repository_1.LibraryRepository,
        machine_learning_repository_1.MachineLearningRepository,
        map_repository_1.MapRepository,
        media_repository_1.MediaRepository,
        memory_repository_1.MemoryRepository,
        metadata_repository_1.MetadataRepository,
        move_repository_1.MoveRepository,
        notification_repository_1.NotificationRepository,
        oauth_repository_1.OAuthRepository,
        partner_repository_1.PartnerRepository,
        person_repository_1.PersonRepository,
        process_repository_1.ProcessRepository,
        search_repository_1.SearchRepository,
        server_info_repository_1.ServerInfoRepository,
        session_repository_1.SessionRepository,
        shared_link_repository_1.SharedLinkRepository,
        stack_repository_1.StackRepository,
        storage_repository_1.StorageRepository,
        sync_repository_1.SyncRepository,
        sync_checkpoint_repository_1.SyncCheckpointRepository,
        system_metadata_repository_1.SystemMetadataRepository,
        tag_repository_1.TagRepository,
        telemetry_repository_1.TelemetryRepository,
        trash_repository_1.TrashRepository,
        user_repository_1.UserRepository,
        version_history_repository_1.VersionHistoryRepository,
        view_repository_1.ViewRepository])
], BaseService);
//# sourceMappingURL=base.service.js.map