import { UserAdminResponseDto } from 'src/dtos/user.dto';
import { BaseService } from 'src/services/base.service';
export declare class CliService extends BaseService {
    listUsers(): Promise<UserAdminResponseDto[]>;
    resetAdminPassword(ask: (admin: UserAdminResponseDto) => Promise<string | undefined>): Promise<{
        admin: {
            id: string;
            name: string;
            updatedAt: Date;
            email: string;
            createdAt: Date;
            profileImagePath: string;
            isAdmin: boolean;
            shouldChangePassword: boolean;
            avatarColor: import("../enum").UserAvatarColor | null;
            deletedAt: Date | null;
            oauthId: string;
            storageLabel: string | null;
            quotaSizeInBytes: number | null;
            quotaUsageInBytes: number;
            status: import("../enum").UserStatus;
            profileChangedAt: Date;
            metadata: {
                key: import("../enum").UserMetadataKey;
                value: {
                    albums?: {
                        defaultAssetOrder?: import("../enum").AssetOrder | undefined;
                    } | undefined;
                    folders?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    memories?: {
                        enabled?: boolean | undefined;
                    } | undefined;
                    people?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    ratings?: {
                        enabled?: boolean | undefined;
                    } | undefined;
                    sharedLinks?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    tags?: {
                        enabled?: boolean | undefined;
                        sidebarWeb?: boolean | undefined;
                    } | undefined;
                    emailNotifications?: {
                        enabled?: boolean | undefined;
                        albumInvite?: boolean | undefined;
                        albumUpdate?: boolean | undefined;
                    } | undefined;
                    download?: {
                        archiveSize?: number | undefined;
                        includeEmbeddedVideos?: boolean | undefined;
                    } | undefined;
                    purchase?: {
                        showSupportBadge?: boolean | undefined;
                        hideBuyButtonUntil?: string | undefined;
                    } | undefined;
                    cast?: {
                        gCastEnabled?: boolean | undefined;
                    } | undefined;
                } | {
                    licenseKey: string;
                    activationKey: string;
                    activatedAt: string;
                } | {
                    isOnboarded: boolean;
                };
            }[];
        };
        password: string;
        provided: boolean;
    }>;
    disablePasswordLogin(): Promise<void>;
    enablePasswordLogin(): Promise<void>;
    grantAdminAccess(email: string): Promise<void>;
    revokeAdminAccess(email: string): Promise<void>;
    disableOAuthLogin(): Promise<void>;
    enableOAuthLogin(): Promise<void>;
    getSampleFilePaths(): Promise<string[]>;
    migrateFilePaths({ oldValue, newValue, confirm, }: {
        oldValue: string;
        newValue: string;
        confirm: (data: {
            sourceFolder: string;
            targetFolder: string;
        }) => Promise<boolean>;
    }): Promise<boolean>;
    cleanup(): Promise<void>;
}
