import { ClassConstructor } from 'class-transformer';
import { AllJobStatusResponseDto, JobCommandDto, JobCreateDto, JobStatusDto } from 'src/dtos/job.dto';
import { QueueName } from 'src/enum';
import { ArgOf, ArgsOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class JobService extends BaseService {
    private services;
    private nightlyJobsLock;
    onConfigInit({ newConfig: config }: ArgOf<'ConfigInit'>): Promise<void>;
    onConfigUpdate({ newConfig: config }: ArgOf<'ConfigUpdate'>): void;
    onBootstrap(): void;
    private updateQueueConcurrency;
    setServices(services: ClassConstructor<unknown>[]): void;
    create(dto: JobCreateDto): Promise<void>;
    handleCommand(queueName: QueueName, dto: JobCommandDto): Promise<JobStatusDto>;
    getJobStatus(queueName: QueueName): Promise<JobStatusDto>;
    getAllJobsStatus(): Promise<AllJobStatusResponseDto>;
    private start;
    onJobStart(...[queueName, job]: ArgsOf<'JobStart'>): Promise<void>;
    private isConcurrentQueue;
    handleNightlyJobs(): Promise<void>;
    private onDone;
}
