"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MapService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("./base.service");
const asset_util_1 = require("../utils/asset.util");
let MapService = class MapService extends base_service_1.BaseService {
    async getMapMarkers(auth, options) {
        const userIds = [auth.user.id];
        if (options.withPartners) {
            const partnerIds = await (0, asset_util_1.getMyPartnerIds)({ userId: auth.user.id, repository: this.partnerRepository });
            userIds.push(...partnerIds);
        }
        const albumIds = [];
        if (options.withSharedAlbums) {
            const [ownedAlbums, sharedAlbums] = await Promise.all([
                this.albumRepository.getOwned(auth.user.id),
                this.albumRepository.getShared(auth.user.id),
            ]);
            albumIds.push(...ownedAlbums.map((album) => album.id), ...sharedAlbums.map((album) => album.id));
        }
        return this.mapRepository.getMapMarkers(userIds, albumIds, options);
    }
    async reverseGeocode(dto) {
        const { lat: latitude, lon: longitude } = dto;
        const result = await this.mapRepository.reverseGeocode({ latitude, longitude });
        return result ? [result] : [];
    }
};
exports.MapService = MapService;
exports.MapService = MapService = __decorate([
    (0, common_1.Injectable)()
], MapService);
//# sourceMappingURL=map.service.js.map