import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { PersonResponseDto } from 'src/dtos/person.dto';
import { LargeAssetSearchDto, MetadataSearchDto, PlacesResponseDto, RandomSearchDto, SearchPeopleDto, SearchPlacesDto, SearchResponseDto, SearchStatisticsResponseDto, SearchSuggestionRequestDto, SmartSearchDto, StatisticsSearchDto } from 'src/dtos/search.dto';
import { BaseService } from 'src/services/base.service';
export declare class SearchService extends BaseService {
    private embeddingCache;
    searchPerson(auth: AuthDto, dto: SearchPeopleDto): Promise<PersonResponseDto[]>;
    searchPlaces(dto: SearchPlacesDto): Promise<PlacesResponseDto[]>;
    getExploreData(auth: AuthDto): Promise<{
        fieldName: string;
        items: {
            value: string;
            data: AssetResponseDto;
        }[];
    }[]>;
    searchMetadata(auth: AuthDto, dto: MetadataSearchDto): Promise<SearchResponseDto>;
    searchStatistics(auth: AuthDto, dto: StatisticsSearchDto): Promise<SearchStatisticsResponseDto>;
    searchRandom(auth: AuthDto, dto: RandomSearchDto): Promise<AssetResponseDto[]>;
    searchLargeAssets(auth: AuthDto, dto: LargeAssetSearchDto): Promise<AssetResponseDto[]>;
    searchSmart(auth: AuthDto, dto: SmartSearchDto): Promise<SearchResponseDto>;
    getAssetsByCity(auth: AuthDto): Promise<AssetResponseDto[]>;
    getSearchSuggestions(auth: AuthDto, dto: SearchSuggestionRequestDto): Promise<(string | null)[]>;
    private getSuggestions;
    private getUserIdsToSearch;
    private mapResponse;
}
