"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionService = void 0;
const common_1 = require("@nestjs/common");
const luxon_1 = require("luxon");
const decorators_1 = require("../decorators");
const session_dto_1 = require("../dtos/session.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
let SessionService = class SessionService extends base_service_1.BaseService {
    async handleCleanup() {
        const sessions = await this.sessionRepository.cleanup();
        for (const session of sessions) {
            this.logger.verbose(`Deleted expired session token: ${session.deviceOS}/${session.deviceType}`);
        }
        this.logger.log(`Deleted ${sessions.length} expired session tokens`);
        return enum_1.JobStatus.Success;
    }
    async create(auth, dto) {
        if (!auth.session) {
            throw new common_1.BadRequestException('This endpoint can only be used with a session token');
        }
        const token = this.cryptoRepository.randomBytesAsText(32);
        const tokenHashed = this.cryptoRepository.hashSha256(token);
        const session = await this.sessionRepository.create({
            parentId: auth.session.id,
            userId: auth.user.id,
            expiresAt: dto.duration ? luxon_1.DateTime.now().plus({ seconds: dto.duration }).toJSDate() : null,
            deviceType: dto.deviceType,
            deviceOS: dto.deviceOS,
            token: tokenHashed,
        });
        return { ...(0, session_dto_1.mapSession)(session), token };
    }
    async getAll(auth) {
        const sessions = await this.sessionRepository.getByUserId(auth.user.id);
        return sessions.map((session) => (0, session_dto_1.mapSession)(session, auth.session?.id));
    }
    async update(auth, id, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.SessionUpdate, ids: [id] });
        if (Object.values(dto).filter((prop) => prop !== undefined).length === 0) {
            throw new common_1.BadRequestException('No fields to update');
        }
        const session = await this.sessionRepository.update(id, {
            isPendingSyncReset: dto.isPendingSyncReset,
        });
        return (0, session_dto_1.mapSession)(session);
    }
    async delete(auth, id) {
        await this.requireAccess({ auth, permission: enum_1.Permission.AuthDeviceDelete, ids: [id] });
        await this.sessionRepository.delete(id);
    }
    async lock(auth, id) {
        await this.requireAccess({ auth, permission: enum_1.Permission.SessionLock, ids: [id] });
        await this.sessionRepository.update(id, { pinExpiresAt: null });
    }
    async deleteAll(auth) {
        const sessions = await this.sessionRepository.getByUserId(auth.user.id);
        for (const session of sessions) {
            if (session.id === auth.session?.id) {
                continue;
            }
            await this.sessionRepository.delete(session.id);
        }
    }
};
exports.SessionService = SessionService;
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.SessionCleanup, queue: enum_1.QueueName.BackgroundTask }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SessionService.prototype, "handleCleanup", null);
exports.SessionService = SessionService = __decorate([
    (0, common_1.Injectable)()
], SessionService);
//# sourceMappingURL=session.service.js.map