import { BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { StackCreateDto, StackResponseDto, StackSearchDto, StackUpdateDto } from 'src/dtos/stack.dto';
import { BaseService } from 'src/services/base.service';
import { UUIDAssetIDParamDto } from 'src/validation';
export declare class StackService extends BaseService {
    search(auth: AuthDto, dto: StackSearchDto): Promise<StackResponseDto[]>;
    create(auth: AuthDto, dto: StackCreateDto): Promise<StackResponseDto>;
    get(auth: AuthDto, id: string): Promise<StackResponseDto>;
    update(auth: AuthDto, id: string, dto: StackUpdateDto): Promise<StackResponseDto>;
    delete(auth: AuthDto, id: string): Promise<void>;
    deleteAll(auth: AuthDto, dto: BulkIdsDto): Promise<void>;
    removeAsset(auth: AuthDto, dto: UUIDAssetIDParamDto): Promise<void>;
    private findOrFail;
}
