"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagService = void 0;
const common_1 = require("@nestjs/common");
const decorators_1 = require("../decorators");
const tag_dto_1 = require("../dtos/tag.dto");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const asset_util_1 = require("../utils/asset.util");
const tag_1 = require("../utils/tag");
let TagService = class TagService extends base_service_1.BaseService {
    async getAll(auth) {
        const tags = await this.tagRepository.getAll(auth.user.id);
        return tags.map((tag) => (0, tag_dto_1.mapTag)(tag));
    }
    async get(auth, id) {
        await this.requireAccess({ auth, permission: enum_1.Permission.TagRead, ids: [id] });
        const tag = await this.findOrFail(id);
        return (0, tag_dto_1.mapTag)(tag);
    }
    async create(auth, dto) {
        let parent;
        if (dto.parentId) {
            await this.requireAccess({ auth, permission: enum_1.Permission.TagRead, ids: [dto.parentId] });
            parent = await this.tagRepository.get(dto.parentId);
            if (!parent) {
                throw new common_1.BadRequestException('Tag not found');
            }
        }
        const userId = auth.user.id;
        const value = parent ? `${parent.value}/${dto.name}` : dto.name;
        const duplicate = await this.tagRepository.getByValue(userId, value);
        if (duplicate) {
            throw new common_1.BadRequestException(`A tag with that name already exists`);
        }
        const { color } = dto;
        const tag = await this.tagRepository.create({ userId, value, color, parentId: parent?.id });
        return (0, tag_dto_1.mapTag)(tag);
    }
    async update(auth, id, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.TagUpdate, ids: [id] });
        const { color } = dto;
        const tag = await this.tagRepository.update(id, { color });
        return (0, tag_dto_1.mapTag)(tag);
    }
    async upsert(auth, dto) {
        const tags = await (0, tag_1.upsertTags)(this.tagRepository, { userId: auth.user.id, tags: dto.tags });
        return tags.map((tag) => (0, tag_dto_1.mapTag)(tag));
    }
    async remove(auth, id) {
        await this.requireAccess({ auth, permission: enum_1.Permission.TagDelete, ids: [id] });
        await this.tagRepository.delete(id);
    }
    async bulkTagAssets(auth, dto) {
        const [tagIds, assetIds] = await Promise.all([
            this.checkAccess({ auth, permission: enum_1.Permission.TagAsset, ids: dto.tagIds }),
            this.checkAccess({ auth, permission: enum_1.Permission.AssetUpdate, ids: dto.assetIds }),
        ]);
        const items = [];
        for (const tagsId of tagIds) {
            for (const assetsId of assetIds) {
                items.push({ tagsId, assetsId });
            }
        }
        const results = await this.tagRepository.upsertAssetIds(items);
        for (const assetId of new Set(results.map((item) => item.assetsId))) {
            await this.eventRepository.emit('AssetTag', { assetId });
        }
        return { count: results.length };
    }
    async addAssets(auth, id, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.TagAsset, ids: [id] });
        const results = await (0, asset_util_1.addAssets)(auth, { access: this.accessRepository, bulk: this.tagRepository }, { parentId: id, assetIds: dto.ids });
        for (const { id: assetId, success } of results) {
            if (success) {
                await this.eventRepository.emit('AssetTag', { assetId });
            }
        }
        return results;
    }
    async removeAssets(auth, id, dto) {
        await this.requireAccess({ auth, permission: enum_1.Permission.TagAsset, ids: [id] });
        const results = await (0, asset_util_1.removeAssets)(auth, { access: this.accessRepository, bulk: this.tagRepository }, { parentId: id, assetIds: dto.ids, canAlwaysRemove: enum_1.Permission.TagDelete });
        for (const { id: assetId, success } of results) {
            if (success) {
                await this.eventRepository.emit('AssetUntag', { assetId });
            }
        }
        return results;
    }
    async handleTagCleanup() {
        await this.tagRepository.deleteEmptyTags();
        return enum_1.JobStatus.Success;
    }
    async findOrFail(id) {
        const tag = await this.tagRepository.get(id);
        if (!tag) {
            throw new common_1.BadRequestException('Tag not found');
        }
        return tag;
    }
};
exports.TagService = TagService;
__decorate([
    (0, decorators_1.OnJob)({ name: enum_1.JobName.TagCleanup, queue: enum_1.QueueName.BackgroundTask }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TagService.prototype, "handleTagCleanup", null);
exports.TagService = TagService = __decorate([
    (0, common_1.Injectable)()
], TagService);
//# sourceMappingURL=tag.service.js.map