"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimelineService = void 0;
const common_1 = require("@nestjs/common");
const enum_1 = require("../enum");
const base_service_1 = require("./base.service");
const access_1 = require("../utils/access");
const asset_util_1 = require("../utils/asset.util");
let TimelineService = class TimelineService extends base_service_1.BaseService {
    async getTimeBuckets(auth, dto) {
        await this.timeBucketChecks(auth, dto);
        const timeBucketOptions = await this.buildTimeBucketOptions(auth, dto);
        return await this.assetRepository.getTimeBuckets(timeBucketOptions);
    }
    async getTimeBucket(auth, dto) {
        await this.timeBucketChecks(auth, dto);
        const timeBucketOptions = await this.buildTimeBucketOptions(auth, { ...dto });
        const bucket = await this.assetRepository.getTimeBucket(dto.timeBucket, timeBucketOptions);
        return bucket.assets;
    }
    async buildTimeBucketOptions(auth, dto) {
        const { userId, ...options } = dto;
        let userIds = undefined;
        if (userId) {
            userIds = [userId];
            if (dto.withPartners) {
                const partnerIds = await (0, asset_util_1.getMyPartnerIds)({
                    userId: auth.user.id,
                    repository: this.partnerRepository,
                    timelineEnabled: true,
                });
                userIds.push(...partnerIds);
            }
        }
        return { ...options, userIds };
    }
    async timeBucketChecks(auth, dto) {
        if (dto.visibility === enum_1.AssetVisibility.Locked) {
            (0, access_1.requireElevatedPermission)(auth);
        }
        if (dto.albumId) {
            await this.requireAccess({ auth, permission: enum_1.Permission.AlbumRead, ids: [dto.albumId] });
        }
        else {
            dto.userId = dto.userId || auth.user.id;
        }
        if (dto.userId) {
            await this.requireAccess({ auth, permission: enum_1.Permission.TimelineRead, ids: [dto.userId] });
            if (dto.visibility === enum_1.AssetVisibility.Archive) {
                await this.requireAccess({ auth, permission: enum_1.Permission.ArchiveRead, ids: [dto.userId] });
            }
        }
        if (dto.tagId) {
            await this.requireAccess({ auth, permission: enum_1.Permission.TagRead, ids: [dto.tagId] });
        }
        if (dto.withPartners) {
            const requestedArchived = dto.visibility === enum_1.AssetVisibility.Archive || dto.visibility === undefined;
            const requestedFavorite = dto.isFavorite === true || dto.isFavorite === false;
            const requestedTrash = dto.isTrashed === true;
            if (requestedArchived || requestedFavorite || requestedTrash) {
                throw new common_1.BadRequestException('withPartners is only supported for non-archived, non-trashed, non-favorited assets');
            }
        }
    }
};
exports.TimelineService = TimelineService;
exports.TimelineService = TimelineService = __decorate([
    (0, common_1.Injectable)()
], TimelineService);
//# sourceMappingURL=timeline.service.js.map