import { AssetStatsDto, AssetStatsResponseDto } from 'src/dtos/asset.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { UserPreferencesResponseDto, UserPreferencesUpdateDto } from 'src/dtos/user-preferences.dto';
import { UserAdminCreateDto, UserAdminDeleteDto, UserAdminResponseDto, UserAdminSearchDto, UserAdminUpdateDto } from 'src/dtos/user.dto';
import { BaseService } from 'src/services/base.service';
export declare class UserAdminService extends BaseService {
    search(auth: AuthDto, dto: UserAdminSearchDto): Promise<UserAdminResponseDto[]>;
    create(dto: UserAdminCreateDto): Promise<UserAdminResponseDto>;
    get(auth: AuthDto, id: string): Promise<UserAdminResponseDto>;
    update(auth: AuthDto, id: string, dto: UserAdminUpdateDto): Promise<UserAdminResponseDto>;
    delete(auth: AuthDto, id: string, dto: UserAdminDeleteDto): Promise<UserAdminResponseDto>;
    restore(auth: AuthDto, id: string): Promise<UserAdminResponseDto>;
    getStatistics(auth: AuthDto, id: string, dto: AssetStatsDto): Promise<AssetStatsResponseDto>;
    getPreferences(auth: AuthDto, id: string): Promise<UserPreferencesResponseDto>;
    updatePreferences(auth: AuthDto, id: string, dto: UserPreferencesUpdateDto): Promise<UserPreferencesResponseDto>;
    private findOrFail;
}
