import { AuthDto } from 'src/dtos/auth.dto';
import { LicenseKeyDto, LicenseResponseDto } from 'src/dtos/license.dto';
import { OnboardingDto, OnboardingResponseDto } from 'src/dtos/onboarding.dto';
import { UserPreferencesResponseDto, UserPreferencesUpdateDto } from 'src/dtos/user-preferences.dto';
import { CreateProfileImageResponseDto } from 'src/dtos/user-profile.dto';
import { UserAdminResponseDto, UserResponseDto, UserUpdateMeDto } from 'src/dtos/user.dto';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
import { ImmichFileResponse } from 'src/utils/file';
export declare class UserService extends BaseService {
    search(auth: AuthDto): Promise<UserResponseDto[]>;
    getMe(auth: AuthDto): Promise<UserAdminResponseDto>;
    updateMe({ user }: AuthDto, dto: UserUpdateMeDto): Promise<UserAdminResponseDto>;
    getMyPreferences(auth: AuthDto): Promise<UserPreferencesResponseDto>;
    updateMyPreferences(auth: AuthDto, dto: UserPreferencesUpdateDto): Promise<UserPreferencesResponseDto>;
    get(id: string): Promise<UserResponseDto>;
    createProfileImage(auth: AuthDto, file: Express.Multer.File): Promise<CreateProfileImageResponseDto>;
    deleteProfileImage(auth: AuthDto): Promise<void>;
    getProfileImage(id: string): Promise<ImmichFileResponse>;
    getLicense(auth: AuthDto): Promise<LicenseResponseDto>;
    deleteLicense({ user }: AuthDto): Promise<void>;
    setLicense(auth: AuthDto, license: LicenseKeyDto): Promise<LicenseResponseDto>;
    getOnboarding(auth: AuthDto): Promise<OnboardingResponseDto>;
    deleteOnboarding({ user }: AuthDto): Promise<void>;
    setOnboarding(auth: AuthDto, onboarding: OnboardingDto): Promise<OnboardingResponseDto>;
    onBootstrap(): Promise<void>;
    handleUserSyncUsage(): Promise<JobStatus>;
    handleUserDeleteCheck(): Promise<JobStatus>;
    handleUserDelete({ id, force }: JobOf<JobName.UserDelete>): Promise<JobStatus>;
    private isReadyForDeletion;
    private findOrFail;
}
