"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformEnums = void 0;
const transformEnums = (ctx, item) => {
    switch (item.type) {
        case 'EnumCreate': {
            return asEnumCreate(item.enum);
        }
        case 'EnumDrop': {
            return asEnumDrop(item.enumName);
        }
        default: {
            return false;
        }
    }
};
exports.transformEnums = transformEnums;
const asEnumCreate = ({ name, values }) => {
    return `CREATE TYPE "${name}" AS ENUM (${values.map((value) => `'${value}'`)});`;
};
const asEnumDrop = (enumName) => {
    return `DROP TYPE "${enumName}";`;
};
//# sourceMappingURL=enum.transformer.js.map