"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asFunctionCreate = exports.transformFunctions = void 0;
const transformFunctions = (ctx, item) => {
    switch (item.type) {
        case 'FunctionCreate': {
            return (0, exports.asFunctionCreate)(item.function);
        }
        case 'FunctionDrop': {
            return asFunctionDrop(item.functionName);
        }
        default: {
            return false;
        }
    }
};
exports.transformFunctions = transformFunctions;
const asFunctionCreate = (func) => {
    return func.expression;
};
exports.asFunctionCreate = asFunctionCreate;
const asFunctionDrop = (functionName) => {
    return `DROP FUNCTION ${functionName};`;
};
//# sourceMappingURL=function.transformer.js.map