"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformTables = void 0;
const helpers_1 = require("../helpers");
const column_transformer_1 = require("./column.transformer");
const constraint_transformer_1 = require("./constraint.transformer");
const index_transformer_1 = require("./index.transformer");
const trigger_transformer_1 = require("./trigger.transformer");
const transformTables = (ctx, item) => {
    switch (item.type) {
        case 'TableCreate': {
            return asTableCreate(item.table);
        }
        case 'TableDrop': {
            return asTableDrop(item.tableName);
        }
        default: {
            return false;
        }
    }
};
exports.transformTables = transformTables;
const asTableCreate = (table) => {
    const tableName = table.name;
    const items = [];
    for (const column of table.columns) {
        items.push(`"${column.name}" ${(0, helpers_1.getColumnType)(column)}${(0, helpers_1.getColumnModifiers)(column)}`);
    }
    for (const constraint of table.constraints) {
        items.push((0, constraint_transformer_1.asConstraintBody)(constraint));
    }
    const sql = [`CREATE TABLE "${tableName}" (\n  ${items.join(',\n  ')}\n);`];
    for (const column of table.columns) {
        if (column.comment) {
            sql.push((0, helpers_1.asColumnComment)(tableName, column.name, column.comment));
        }
        if (column.storage) {
            sql.push(...(0, column_transformer_1.asColumnAlter)(tableName, column.name, { storage: column.storage }));
        }
    }
    for (const index of table.indexes) {
        sql.push((0, index_transformer_1.asIndexCreate)(index));
    }
    for (const trigger of table.triggers) {
        sql.push((0, trigger_transformer_1.asTriggerCreate)(trigger));
    }
    return sql;
};
const asTableDrop = (tableName) => {
    return `DROP TABLE "${tableName}";`;
};
//# sourceMappingURL=table.transformer.js.map