import { StreamableFile } from '@nestjs/common';
import { NextFunction, Response } from 'express';
import { CacheControl } from 'src/enum';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { ImmichReadStream } from 'src/repositories/storage.repository';
export declare function getFileNameWithoutExtension(path: string): string;
export declare function getFilenameExtension(path: string): string;
export declare function getLivePhotoMotionFilename(stillName: string, motionName: string): string;
export declare class ImmichFileResponse {
    readonly path: string;
    readonly contentType: string;
    readonly cacheControl: CacheControl;
    readonly fileName?: string;
    constructor(response: ImmichFileResponse);
}
export declare const sendFile: (res: Response, next: NextFunction, handler: () => Promise<ImmichFileResponse>, logger: LoggingRepository) => Promise<void>;
export declare const asStreamableFile: ({ stream, type, length }: ImmichReadStream) => StreamableFile;
