"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergePreferences = exports.getPreferencesPartial = exports.getPreferences = void 0;
const lodash_1 = __importDefault(require("lodash"));
const enum_1 = require("../enum");
const bytes_1 = require("./bytes");
const misc_1 = require("./misc");
const getDefaultPreferences = () => {
    return {
        albums: {
            defaultAssetOrder: enum_1.AssetOrder.Desc,
        },
        folders: {
            enabled: false,
            sidebarWeb: false,
        },
        memories: {
            enabled: true,
        },
        people: {
            enabled: true,
            sidebarWeb: false,
        },
        sharedLinks: {
            enabled: true,
            sidebarWeb: false,
        },
        ratings: {
            enabled: false,
        },
        tags: {
            enabled: false,
            sidebarWeb: false,
        },
        emailNotifications: {
            enabled: true,
            albumInvite: true,
            albumUpdate: true,
        },
        download: {
            archiveSize: bytes_1.HumanReadableSize.GiB * 4,
            includeEmbeddedVideos: false,
        },
        purchase: {
            showSupportBadge: true,
            hideBuyButtonUntil: new Date(2022, 1, 12).toISOString(),
        },
        cast: {
            gCastEnabled: false,
        },
    };
};
const getPreferences = (metadata) => {
    const preferences = getDefaultPreferences();
    const item = metadata.find(({ key }) => key === enum_1.UserMetadataKey.Preferences);
    const partial = item?.value || {};
    for (const property of (0, misc_1.getKeysDeep)(partial)) {
        lodash_1.default.set(preferences, property, lodash_1.default.get(partial, property));
    }
    return preferences;
};
exports.getPreferences = getPreferences;
const getPreferencesPartial = (newPreferences) => {
    const defaultPreferences = getDefaultPreferences();
    const partial = {};
    for (const property of (0, misc_1.getKeysDeep)(defaultPreferences)) {
        const newValue = lodash_1.default.get(newPreferences, property);
        const isEmpty = newValue === undefined || newValue === null || newValue === '';
        const defaultValue = lodash_1.default.get(defaultPreferences, property);
        const isEqual = newValue === defaultValue || lodash_1.default.isEqual(newValue, defaultValue);
        if (isEmpty || isEqual) {
            continue;
        }
        lodash_1.default.set(partial, property, newValue);
    }
    return partial;
};
exports.getPreferencesPartial = getPreferencesPartial;
const mergePreferences = (preferences, dto) => {
    for (const key of (0, misc_1.getKeysDeep)(dto)) {
        lodash_1.default.set(preferences, key, lodash_1.default.get(dto, key));
    }
    return preferences;
};
exports.mergePreferences = mergePreferences;
//# sourceMappingURL=preferences.js.map