"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.respondWithoutCookie = exports.respondWithCookie = void 0;
const luxon_1 = require("luxon");
const enum_1 = require("../enum");
const respondWithCookie = (res, body, { isSecure, values }) => {
    const defaults = {
        path: '/',
        sameSite: 'lax',
        httpOnly: true,
        secure: isSecure,
        maxAge: luxon_1.Duration.fromObject({ days: 400 }).toMillis(),
    };
    const cookieOptions = {
        [enum_1.ImmichCookie.AuthType]: defaults,
        [enum_1.ImmichCookie.AccessToken]: defaults,
        [enum_1.ImmichCookie.OAuthState]: defaults,
        [enum_1.ImmichCookie.OAuthCodeVerifier]: defaults,
        [enum_1.ImmichCookie.IsAuthenticated]: { ...defaults, httpOnly: false },
        [enum_1.ImmichCookie.SharedLinkToken]: { ...defaults, maxAge: luxon_1.Duration.fromObject({ days: 1 }).toMillis() },
    };
    for (const { key, value } of values) {
        const options = cookieOptions[key];
        res.cookie(key, value, options);
    }
    return body;
};
exports.respondWithCookie = respondWithCookie;
const respondWithoutCookie = (res, body, cookies) => {
    for (const cookie of cookies) {
        res.clearCookie(cookie);
    }
    return body;
};
exports.respondWithoutCookie = respondWithoutCookie;
//# sourceMappingURL=response.js.map