"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.count = exports.filterInPlace = void 0;
/**
 * Remove all elements from the given array that return false from the given
 * predicate `filter`.
 */
function filterInPlace(arr, filter) {
    const len = arr.length;
    let j = 0;
    // PERF: for-loop to avoid the additional closure from a forEach
    for (let i = 0; i < len; i++) {
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const ea = arr[i];
        if (filter(ea)) {
            if (i !== j)
                arr[j] = ea;
            j++;
        }
    }
    arr.length = j;
    return arr;
}
exports.filterInPlace = filterInPlace;
function count(arr, predicate) {
    let acc = 0;
    for (let idx = 0; idx < arr.length; idx++) {
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        if (predicate(arr[idx], idx))
            acc++;
    }
    return acc;
}
exports.count = count;
//# sourceMappingURL=Array.js.map