"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asError = exports.cleanError = exports.tryEach = void 0;
const String_1 = require("./String");
/**
 * When we wrap errors, an Error always prefixes the toString() and stack with
 * "Error: ", so we can remove that prefix.
 */
function tryEach(arr) {
    for (const f of arr) {
        try {
            f();
        }
        catch (_) {
            //
        }
    }
}
exports.tryEach = tryEach;
function cleanError(s) {
    return String(s)
        .trim()
        .replace(/^error: /i, "");
}
exports.cleanError = cleanError;
function asError(err) {
    return err instanceof Error
        ? err
        : new Error((0, String_1.blank)(err) ? "(unknown)" : (0, String_1.toS)(err));
}
exports.asError = asError;
//# sourceMappingURL=Error.js.map