/**
 * Includes all the scripts needed by the queue and jobs.
 */
import { JobJson, JobJsonRaw, MinimalJob, MoveToWaitingChildrenOpts, ParentKeyOpts, RedisClient, KeepJobs, MoveToDelayedOpts, RepeatableOptions, RetryJobOpts, ScriptQueueContext } from '../interfaces';
import { JobsOptions, JobState, JobType, FinishedStatus, FinishedPropValAttribute, RedisJobOptions, JobProgress } from '../types';
import { ChainableCommander } from 'ioredis';
export type JobData = [JobJsonRaw | number, string?];
export declare class Scripts {
    protected queue: ScriptQueueContext;
    protected version: string;
    moveToFinishedKeys: (string | undefined)[];
    constructor(queue: ScriptQueueContext);
    execCommand(client: RedisClient | ChainableCommander, commandName: string, args: any[]): any;
    isJobInList(listKey: string, jobId: string): Promise<boolean>;
    protected addDelayedJobArgs(job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): (string | Buffer)[];
    protected addDelayedJob(client: RedisClient, job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): Promise<string | number>;
    protected addPrioritizedJobArgs(job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): (string | Buffer)[];
    protected addPrioritizedJob(client: RedisClient, job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): Promise<string | number>;
    protected addParentJobArgs(job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): (string | Buffer)[];
    protected addParentJob(client: RedisClient, job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): Promise<string | number>;
    protected addStandardJobArgs(job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): (string | Buffer)[];
    protected addStandardJob(client: RedisClient, job: JobJson, encodedOpts: any, args: (string | number | Record<string, any>)[]): Promise<string | number>;
    addJob(client: RedisClient, job: JobJson, opts: RedisJobOptions, jobId: string, parentKeyOpts?: ParentKeyOpts): Promise<string>;
    protected pauseArgs(pause: boolean): (string | number)[];
    pause(pause: boolean): Promise<void>;
    protected addRepeatableJobArgs(customKey: string, nextMillis: number, opts: RepeatableOptions, legacyCustomKey: string): (string | number | Buffer)[];
    addRepeatableJob(customKey: string, nextMillis: number, opts: RepeatableOptions, legacyCustomKey: string): Promise<string>;
    addJobScheduler(jobSchedulerId: string, nextMillis: number, templateData: string, templateOpts: RedisJobOptions, opts: RepeatableOptions, delayedJobOpts: JobsOptions, producerId?: string): Promise<[string, number]>;
    updateRepeatableJobMillis(client: RedisClient, customKey: string, nextMillis: number, legacyCustomKey: string): Promise<string>;
    updateJobSchedulerNextMillis(jobSchedulerId: string, nextMillis: number, templateData: string, delayedJobOpts: JobsOptions, producerId?: string): Promise<string | null>;
    private removeRepeatableArgs;
    getRepeatConcatOptions(repeatConcatOptions: string, repeatJobKey: string): string;
    removeRepeatable(legacyRepeatJobId: string, repeatConcatOptions: string, repeatJobKey: string): Promise<number>;
    removeJobScheduler(jobSchedulerId: string): Promise<number>;
    protected removeArgs(jobId: string, removeChildren: boolean): (string | number)[];
    remove(jobId: string, removeChildren: boolean): Promise<number>;
    removeUnprocessedChildren(jobId: string): Promise<void>;
    extendLock(jobId: string, token: string, duration: number, client?: RedisClient | ChainableCommander): Promise<number>;
    extendLocks(jobIds: string[], tokens: string[], duration: number): Promise<string[]>;
    updateData<T = any, R = any, N extends string = string>(job: MinimalJob<T, R, N>, data: T): Promise<void>;
    updateProgress(jobId: string, progress: JobProgress): Promise<void>;
    addLog(jobId: string, logRow: string, keepLogs?: number): Promise<number>;
    protected moveToFinishedArgs<T = any, R = any, N extends string = string>(job: MinimalJob<T, R, N>, val: any, propVal: FinishedPropValAttribute, shouldRemove: undefined | boolean | number | KeepJobs, target: FinishedStatus, token: string, timestamp: number, fetchNext?: boolean, fieldsToUpdate?: Record<string, any>): (string | number | boolean | Buffer)[];
    protected getKeepJobs(shouldRemove: undefined | boolean | number | KeepJobs, workerKeepJobs: undefined | KeepJobs): KeepJobs;
    moveToFinished(jobId: string, args: (string | number | boolean | Buffer)[]): Promise<any[]>;
    private drainArgs;
    drain(delayed: boolean): Promise<void>;
    private removeChildDependencyArgs;
    removeChildDependency(jobId: string, parentKey: string): Promise<boolean>;
    private getRangesArgs;
    getRanges(types: JobType[], start?: number, end?: number, asc?: boolean): Promise<[string][]>;
    private getCountsArgs;
    getCounts(types: JobType[]): Promise<number[]>;
    protected getCountsPerPriorityArgs(priorities: number[]): (string | number)[];
    getCountsPerPriority(priorities: number[]): Promise<number[]>;
    protected getDependencyCountsArgs(jobId: string, types: string[]): (string | number)[];
    getDependencyCounts(jobId: string, types: string[]): Promise<number[]>;
    moveToCompletedArgs<T = any, R = any, N extends string = string>(job: MinimalJob<T, R, N>, returnvalue: R, removeOnComplete: boolean | number | KeepJobs, token: string, fetchNext?: boolean): (string | number | boolean | Buffer)[];
    moveToFailedArgs<T = any, R = any, N extends string = string>(job: MinimalJob<T, R, N>, failedReason: string, removeOnFailed: boolean | number | KeepJobs, token: string, fetchNext?: boolean, fieldsToUpdate?: Record<string, any>): (string | number | boolean | Buffer)[];
    isFinished(jobId: string, returnValue?: boolean): Promise<number | [number, string]>;
    getState(jobId: string): Promise<JobState | 'unknown'>;
    changeDelay(jobId: string, delay: number): Promise<void>;
    private changeDelayArgs;
    changePriority(jobId: string, priority?: number, lifo?: boolean): Promise<void>;
    protected changePriorityArgs(jobId: string, priority?: number, lifo?: boolean): (string | number)[];
    moveToDelayedArgs(jobId: string, timestamp: number, token: string, delay: number, opts?: MoveToDelayedOpts): (string | number | Buffer)[];
    moveToWaitingChildrenArgs(jobId: string, token: string, opts?: MoveToWaitingChildrenOpts): (string | number)[];
    isMaxedArgs(): string[];
    isMaxed(): Promise<boolean>;
    moveToDelayed(jobId: string, timestamp: number, delay: number, token?: string, opts?: MoveToDelayedOpts): Promise<void>;
    /**
     * Move parent job to waiting-children state.
     *
     * @returns true if job is successfully moved, false if there are pending dependencies.
     * @throws JobNotExist
     * This exception is thrown if jobId is missing.
     * @throws JobLockNotExist
     * This exception is thrown if job lock is missing.
     * @throws JobNotInState
     * This exception is thrown if job is not in active state.
     */
    moveToWaitingChildren(jobId: string, token: string, opts?: MoveToWaitingChildrenOpts): Promise<boolean>;
    getRateLimitTtlArgs(maxJobs?: number): (string | number)[];
    getRateLimitTtl(maxJobs?: number): Promise<number>;
    /**
     * Remove jobs in a specific state.
     *
     * @returns Id jobs from the deleted records.
     */
    cleanJobsInSet(set: string, timestamp: number, limit?: number): Promise<string[]>;
    getJobSchedulerArgs(id: string): string[];
    getJobScheduler(id: string): Promise<[any, string | null]>;
    retryJobArgs(jobId: string, lifo: boolean, token: string, opts?: MoveToDelayedOpts): (string | number | Buffer)[];
    retryJob(jobId: string, lifo: boolean, token?: string, opts?: RetryJobOpts): Promise<void>;
    protected moveJobsToWaitArgs(state: FinishedStatus | 'delayed', count: number, timestamp: number): (string | number)[];
    retryJobs(state?: FinishedStatus, count?: number, timestamp?: number): Promise<number>;
    promoteJobs(count?: number): Promise<number>;
    /**
     * Attempts to reprocess a job
     *
     * @param job -
     * @param state - The expected job state. If the job is not found
     * on the provided state, then it's not reprocessed. Supported states: 'failed', 'completed'
     *
     * @returns Returns a promise that evaluates to a return code:
     * 1 means the operation was a success
     * 0 means the job does not exist
     * -1 means the job is currently locked and can't be retried.
     * -2 means the job was not found in the expected set
     */
    reprocessJob<T = any, R = any, N extends string = string>(job: MinimalJob<T, R, N>, state: 'failed' | 'completed'): Promise<void>;
    getMetrics(type: 'completed' | 'failed', start?: number, end?: number): Promise<[string[], string[], number]>;
    moveToActive(client: RedisClient, token: string, name?: string): Promise<any[]>;
    promote(jobId: string): Promise<void>;
    protected moveStalledJobsToWaitArgs(): (string | number)[];
    /**
     * Looks for unlocked jobs in the active queue.
     *
     * The job was being worked on, but the worker process died and it failed to renew the lock.
     * We call these jobs 'stalled'. This is the most common case. We resolve these by moving them
     * back to wait to be re-processed. To prevent jobs from cycling endlessly between active and wait,
     * (e.g. if the job handler keeps crashing),
     * we limit the number stalled job recoveries to settings.maxStalledCount.
     */
    moveStalledJobsToWait(): Promise<string[]>;
    /**
     * Moves a job back from Active to Wait.
     * This script is used when a job has been manually rate limited and needs
     * to be moved back to wait from active status.
     *
     * @param client - Redis client
     * @param jobId - Job id
     * @returns
     */
    moveJobFromActiveToWait(jobId: string, token?: string): Promise<any>;
    obliterate(opts: {
        force: boolean;
        count: number;
    }): Promise<number>;
    /**
     * Paginate a set or hash keys.
     * @param opts - options to define the pagination behaviour
     *
     */
    paginate(key: string, opts: {
        start: number;
        end: number;
        fetchJobs?: boolean;
    }): Promise<{
        cursor: string;
        items: {
            id: string;
            v?: any;
            err?: string;
        }[];
        total: number;
        jobs?: JobJsonRaw[];
    }>;
    finishedErrors({ code, jobId, parentKey, command, state, }: {
        code: number;
        jobId?: string;
        parentKey?: string;
        command: string;
        state?: string;
    }): Error;
}
export declare function raw2NextJobData(raw: any[]): any[];
