import { Maybe, MaybeNull } from "./Maybe";
export declare function isIterable(obj: any): obj is Iterable<any>;
export declare function ifArr(arr: unknown): Maybe<any[]>;
export declare function toA<T>(arr: undefined | null | T[] | T | Iterable<T>): T[];
export declare function compact<T>(array: MaybeNull<T>[]): T[];
/**
 * Remove all elements from the given array that return false from the given
 * predicate `filter`.
 */
export declare function filterInPlace<T>(arr: T[], filter: (t: T) => boolean): T[];
export declare function uniq<T>(arr: T[]): T[];
export declare function shallowArrayEql(a: any[], b: any[]): boolean;
type Comparable = number | string | boolean;
/**
 * Returns a copy of arr, stable sorted by the given constraint. Note that false
 * < true, and that `f` may return an array for sort priorities, or undefined if
 * the item should be skipped from the returned result.
 *
 * Note: localeSort() thinks lower case should come before upper case (!!)
 */
export declare function sortBy<T>(arr: Iterable<Maybe<T>> | Maybe<T>[], f: (t: T) => Maybe<Comparable>): T[];
export declare function leastBy<T>(haystack: T[], f: (t: T) => Maybe<Comparable>): Maybe<T>;
export {};
