import * as bc from "batch-cluster";
import { ExifToolOptions } from "./ExifToolOptions";
import { Omit } from "./Omit";
import { Tags } from "./Tags";
export declare const ConsoleLogger: bc.Logger;
/**
 * Default values for `ExifToolOptions`, except for `processFactory` (which is
 * created by the ExifTool constructor)
 */
export declare const DefaultExifToolOptions: Omit<ExifToolOptions, "processFactory" | "ignoreShebang">;
/**
 * @see https://github.com/photostructure/exiftool-vendored.js/issues/215
 */
export declare function defaultAdjustTimeZoneIfDaylightSavings(t: Tags): number | undefined;
