"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _ExifTime_instances, _ExifTime_dt, _ExifTime_z, _ExifTime_subsec, _ExifTime_shortZone;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExifTime = void 0;
const luxon_1 = require("luxon");
const DateTime_1 = require("./DateTime");
const String_1 = require("./String");
const TimeParsing_1 = require("./TimeParsing");
const Timezones_1 = require("./Timezones");
/**
 * Encodes an ExifTime (which may not have a timezone offset)
 */
class ExifTime {
    static fromEXIF(text, defaultZone) {
        const s = (0, String_1.toS)(text).trim();
        if (s.length === 0)
            return;
        const result = (0, TimeParsing_1.parseDateTime)(text, (0, TimeParsing_1.timeFormats)({ defaultZone }));
        if (result != null) {
            return this.fromDateTime(result.dt, text, result.unsetZone ? undefined : (0, Timezones_1.getZoneName)({ zone: result.dt.zone }), result.inferredZone, result.unsetMilliseconds);
        }
        return;
    }
    static fromDateTime(dt, rawValue, zone, inferredZone, unsetMilliseconds) {
        return !(0, DateTime_1.validDateTime)(dt)
            ? undefined
            : new ExifTime(dt.hour, dt.minute, dt.second, unsetMilliseconds ? undefined : dt.millisecond, rawValue, zone, inferredZone);
    }
    constructor(hour, minute, second, millisecond, rawValue, zoneName, inferredZone) {
        _ExifTime_instances.add(this);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
        this.rawValue = rawValue;
        this.inferredZone = inferredZone;
        _ExifTime_dt.set(this, void 0);
        _ExifTime_z.set(this, void 0);
        this.zone = (0, Timezones_1.getZoneName)({ zoneName });
    }
    toDateTime() {
        var _a;
        return (__classPrivateFieldSet(this, _ExifTime_dt, (_a = __classPrivateFieldGet(this, _ExifTime_dt, "f")) !== null && _a !== void 0 ? _a : luxon_1.DateTime.fromObject({
            hour: this.hour,
            minute: this.minute,
            second: this.second,
            millisecond: this.millisecond,
        }, {
            zone: this.zone,
        }), "f"));
    }
    /**
     * Alias for `.millisecond`
     */
    get millis() {
        return this.millisecond;
    }
    get hasZone() {
        return this.zone != null;
    }
    toString() {
        return ((0, String_1.pad2)(this.hour, this.minute, this.second).join(":") +
            __classPrivateFieldGet(this, _ExifTime_instances, "m", _ExifTime_subsec).call(this) +
            __classPrivateFieldGet(this, _ExifTime_instances, "m", _ExifTime_shortZone).call(this));
    }
    toISOString() {
        return this.toString();
    }
    toExifString() {
        return this.toString();
    }
    setZone(zone, opts) {
        const dt = (0, TimeParsing_1.setZone)({
            zone,
            src: this.toDateTime(),
            srcHasZone: this.hasZone,
            opts,
        });
        return ExifTime.fromDateTime(dt, this.rawValue, this.zone, this.inferredZone, this.millisecond == null);
    }
    toJSON() {
        return {
            _ctor: "ExifTime",
            hour: this.hour,
            minute: this.minute,
            second: this.second,
            millisecond: this.millisecond,
            rawValue: this.rawValue,
            zone: this.zone,
            inferredZone: this.inferredZone,
        };
    }
    static fromJSON(json) {
        return new ExifTime(json.hour, json.minute, json.second, json.millisecond, json.rawValue, json.zone, json.inferredZone);
    }
}
exports.ExifTime = ExifTime;
_ExifTime_dt = new WeakMap(), _ExifTime_z = new WeakMap(), _ExifTime_instances = new WeakSet(), _ExifTime_subsec = function _ExifTime_subsec() {
    return this.millisecond == null ? "" : "." + (0, String_1.pad3)(this.millisecond);
}, _ExifTime_shortZone = function _ExifTime_shortZone() {
    var _a;
    return (__classPrivateFieldSet(this, _ExifTime_z, (_a = __classPrivateFieldGet(this, _ExifTime_z, "f")) !== null && _a !== void 0 ? _a : (0, Timezones_1.zoneToShortOffset)(this.zone), "f"));
};
//# sourceMappingURL=ExifTime.js.map