"use strict";
/* eslint-disable @typescript-eslint/no-explicit-any */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExifToolTagNames = void 0;
exports.isExifToolTag = isExifToolTag;
const Object_1 = require("./Object");
exports.ExifToolTagNames = (0, Object_1.keysOf)({
    ExifToolVersion: true,
    SourceFile: true,
    Error: true,
    Warning: true,
});
/**
 * Is the given tag name intrinsic to the content of a given file? In other
 * words, is it not an artifact of a metadata field?
 */
function isExifToolTag(name) {
    return exports.ExifToolTagNames.includes(name);
}
//# sourceMappingURL=ExifToolTags.js.map