"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeolocationTagNames = void 0;
exports.isGeolocationTag = isGeolocationTag;
exports.GeolocationTagNames = [
    "GeolocationBearing",
    "GeolocationCity",
    "GeolocationCountry",
    "GeolocationCountryCode",
    "GeolocationDistance",
    "GeolocationFeatureCode",
    "GeolocationFeatureType",
    "GeolocationPopulation",
    "GeolocationPosition",
    "GeolocationRegion",
    "GeolocationSubregion",
    "GeolocationTimeZone",
];
/**
 * Is the given tag name intrinsic to the content of a given file? In other
 * words, is it not an artifact of a metadata field?
 */
function isGeolocationTag(name) {
    return exports.GeolocationTagNames.includes(name);
}
//# sourceMappingURL=GeolocationTags.js.map