"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.map = map;
exports.map2 = map2;
exports.first = first;
exports.firstDefinedThunk = firstDefinedThunk;
exports.denull = denull;
function map(maybeT, f) {
    return maybeT == null ? undefined : f(maybeT);
}
function map2(a, b, f) {
    return a == null || b == null ? undefined : f(a, b);
}
function first(iter, f) {
    for (const t of iter) {
        if (t != null) {
            const v = f(t);
            if (v != null)
                return v;
        }
    }
    return;
}
function firstDefinedThunk(iter) {
    for (const f of iter) {
        const result = f();
        if (result != null)
            return result;
    }
    return;
}
/**
 * Convert functions that return `type | null` to `type | undefined`
 */
function denull(t) {
    return t == null ? undefined : t;
}
//# sourceMappingURL=Maybe.js.map