import { Maybe } from "./Maybe";
export declare function isObject(obj: any): obj is Record<string, any>;
export declare function keys<T extends object, K extends string & keyof T>(o: T): K[];
export declare function isFunction(obj: any): obj is () => any;
export declare function fromEntries(arr: Maybe<[Maybe<string>, any]>[], obj?: any): any;
export type Unpick<T, U> = {
    [P in keyof T]: P extends U ? never : T[P];
};
export declare function omit<T extends Record<string, any>, S extends string>(t: T, ...keysToOmit: S[]): Unpick<T, S>;
/**
 * Provides a type-safe exhaustive array of keys for a given interface.
 *
 * Unfortunately, `satisfies (keyof T)[]` doesn't ensure all keys are present,
 * and doesn't guard against duplicates. This function does.
 *
 * @param t - The interface to extract keys from. This is a Record of keys to
 * `true`, which ensures the returned key array is unique.
 */
export declare function keysOf<T>(t: Required<Record<keyof T, true>>): (keyof T)[];
