"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isObject = isObject;
exports.keys = keys;
exports.isFunction = isFunction;
exports.fromEntries = fromEntries;
exports.omit = omit;
exports.keysOf = keysOf;
function isObject(obj) {
    return typeof obj === "object" && obj !== null;
}
function keys(o) {
    return o == null
        ? []
        : Object.keys(o).filter((ea) => ({}).propertyIsEnumerable.call(o, ea));
}
function isFunction(obj) {
    return typeof obj === "function";
}
function fromEntries(arr, obj) {
    if (arr == null || arr.length === 0)
        return obj;
    // don't use Object.create(null), json stringify will break!
    for (const ea of arr.filter((ea) => ea != null)) {
        if (ea != null && Array.isArray(ea)) {
            const [k, v] = ea;
            // allow NULL fields:
            if (k != null && v !== undefined) {
                if (typeof obj !== "object")
                    obj = {};
                obj[k] = v;
            }
        }
    }
    return obj;
}
function omit(t, ...keysToOmit) {
    if (t == null)
        return {};
    const result = { ...t };
    for (const ea of keysToOmit) {
        delete result[ea];
    }
    return result;
}
/**
 * Provides a type-safe exhaustive array of keys for a given interface.
 *
 * Unfortunately, `satisfies (keyof T)[]` doesn't ensure all keys are present,
 * and doesn't guard against duplicates. This function does.
 *
 * @param t - The interface to extract keys from. This is a Record of keys to
 * `true`, which ensures the returned key array is unique.
 */
function keysOf(t) {
    return Object.keys(t);
}
//# sourceMappingURL=Object.js.map