import { ExifToolTask, ExifToolTaskOptions } from "./ExifToolTask";
import { WriteTags } from "./WriteTags";
export declare function htmlEncode(s: string): string;
export declare const WriteTaskOptionFields: ["useMWG", "struct", "ignoreMinorErrors", "writeArgs"];
export declare const DefaultWriteTaskOptions: {
    readonly useMWG: boolean;
    readonly ignoreMinorErrors: boolean;
    readonly struct: "undef" | 0 | 1 | 2;
    readonly writeArgs: string[];
};
export type WriteTaskOptions = Partial<typeof DefaultWriteTaskOptions>;
export interface WriteTaskResult {
    /**
     * Number of files created by ExifTool
     */
    created: number;
    /**
     * Number of files updated by ExifTool. Note that this does not mean any
     * field values were _changed_ from prior values.
     */
    updated: number;
    /**
     * Number of files that ExifTool knew it did not need change. Note that
     * ExifTool (at least as of v12.70) only realizes it doesn't need to change
     * a file if you are clearing an already empty value.
     */
    unchanged: number;
    /**
     * Non-exceptional warnings from ExifTool, like "Error: Nothing to write",
     * or "Nothing to do."
     *
     * Any invalid tag names or values will cause Errors to be thrown.
     */
    warnings?: string[];
}
export declare class WriteTask extends ExifToolTask<WriteTaskResult> {
    readonly sourceFile: string;
    readonly args: string[];
    readonly options: ExifToolTaskOptions;
    constructor(sourceFile: string, args: string[], options: ExifToolTaskOptions);
    static for(filename: string, tags: WriteTags, options: Partial<WriteTaskOptions> & Required<ExifToolTaskOptions>): WriteTask;
    toString(): string;
    parse(data: string, error?: Error): WriteTaskResult;
}
