"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createKyselyProvider = exports.createKyselyClient = void 0;
const kysely_1 = require("kysely");
const constants_1 = require("../constants");
const kysely_service_1 = require("../kysely.service");
const createKyselyClient = ({ config, service }) => {
    const client = new kysely_1.Kysely(config);
    service.addClient(client);
    return client;
};
exports.createKyselyClient = createKyselyClient;
const createKyselyProvider = (options) => {
    if (Array.isArray(options)) {
        return options.map((opt) => {
            return {
                inject: [kysely_service_1.KyselyService],
                provide: (0, constants_1.KYSELY_MODULE_CONNECTION_TOKEN)(opt.namespace),
                useFactory: (kyselyService) => (0, exports.createKyselyClient)({ config: opt, service: kyselyService }),
            };
        });
    }
    else {
        return [{
                inject: [kysely_service_1.KyselyService],
                provide: (0, constants_1.KYSELY_MODULE_CONNECTION_TOKEN)(),
                useFactory: (kyselyService) => (0, exports.createKyselyClient)({ config: options, service: kyselyService }),
            }];
    }
};
exports.createKyselyProvider = createKyselyProvider;
