"use strict";
var KyselyCoreModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KyselyCoreModule = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@nestjs/common");
const constants_1 = require("./constants");
const factories_1 = require("./factories");
const providers_1 = require("./providers");
const kysely_service_1 = require("./kysely.service");
let KyselyCoreModule = KyselyCoreModule_1 = class KyselyCoreModule {
    static forRoot(config) {
        const providers = (0, factories_1.createKyselyProvider)(config);
        return {
            exports: providers,
            module: KyselyCoreModule_1,
            providers: [...providers, kysely_service_1.KyselyService],
        };
    }
    static forRootAsync(options) {
        const provider = {
            inject: [constants_1.KYSELY_MODULE_OPTIONS_TOKEN, kysely_service_1.KyselyService],
            provide: (0, constants_1.KYSELY_MODULE_CONNECTION_TOKEN)(options?.namespace),
            useFactory: (config, service) => (0, factories_1.createKyselyClient)({ config, service }),
        };
        return {
            exports: [provider],
            imports: options.imports,
            module: KyselyCoreModule_1,
            providers: [...(0, providers_1.createAsyncProviders)(options), provider, kysely_service_1.KyselyService],
        };
    }
};
exports.KyselyCoreModule = KyselyCoreModule;
exports.KyselyCoreModule = KyselyCoreModule = KyselyCoreModule_1 = tslib_1.__decorate([
    (0, common_1.Global)(),
    (0, common_1.Module)({})
], KyselyCoreModule);
