"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KyselyService = void 0;
class KyselyService {
    storedActiveClients = new Set();
    get activeClients() {
        return Array.from(this.storedActiveClients);
    }
    addClient(client) {
        this.storedActiveClients.add(client);
    }
    async onApplicationShutdown() {
        for (const client of this.storedActiveClients.values()) {
            try {
                await client.destroy();
                this.storedActiveClients.delete(client);
            }
            catch (e) {
                console.error(`Failed to destroy Kysely client: ${e}`);
            }
        }
    }
}
exports.KyselyService = KyselyService;
