"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAsyncOptionsProvider = exports.createAsyncProviders = void 0;
const constants_1 = require("../constants");
const createAsyncProviders = (options) => {
    const { useExisting, useFactory, useClass } = options;
    if (useExisting || useFactory)
        return [(0, exports.createAsyncOptionsProvider)(options)];
    if (!useClass)
        throw new Error("Invalid options");
    return [(0, exports.createAsyncOptionsProvider)(options), { provide: useClass, useClass }];
};
exports.createAsyncProviders = createAsyncProviders;
const createAsyncOptionsProvider = (options) => {
    const { useFactory, inject, useExisting, useClass } = options;
    if (useFactory) {
        return {
            inject,
            provide: constants_1.KYSELY_MODULE_OPTIONS_TOKEN,
            useFactory,
        };
    }
    if (useExisting) {
        return {
            inject: [useExisting || useClass],
            provide: constants_1.KYSELY_MODULE_OPTIONS_TOKEN,
            useFactory: (optionsFactory) => optionsFactory.createKyselyModuleOptions(),
        };
    }
    throw new Error("Invalid options");
};
exports.createAsyncOptionsProvider = createAsyncOptionsProvider;
