import { OnModuleDestroy, OnModuleInit } from '@nestjs/common';
import { ImmichWorker } from 'src/enum';
import { MaintenanceWorkerService } from 'src/maintenance/maintenance-worker.service';
import { EventRepository } from 'src/repositories/event.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { TelemetryRepository } from 'src/repositories/telemetry.repository';
import { WebsocketRepository } from 'src/repositories/websocket.repository';
import { AuthService } from 'src/services/auth.service';
import { CliService } from 'src/services/cli.service';
import { QueueService } from 'src/services/queue.service';
export declare class BaseModule implements OnModuleInit, OnModuleDestroy {
    private worker;
    private authService;
    private eventRepository;
    private queueService;
    private telemetryRepository;
    private websocketRepository;
    constructor(worker: ImmichWorker, logger: LoggingRepository, authService: AuthService, eventRepository: EventRepository, queueService: QueueService, telemetryRepository: TelemetryRepository, websocketRepository: WebsocketRepository);
    onModuleInit(): Promise<void>;
    onModuleDestroy(): Promise<void>;
}
export declare class ApiModule extends BaseModule {
}
export declare class MaintenanceModule {
    private worker;
    private maintenanceWorkerService;
    constructor(worker: ImmichWorker, logger: LoggingRepository, maintenanceWorkerService: MaintenanceWorkerService);
    onModuleInit(): Promise<void>;
}
export declare class MicroservicesModule extends BaseModule {
}
export declare class ImmichAdminModule implements OnModuleDestroy {
    private service;
    constructor(service: CliService);
    onModuleDestroy(): Promise<void>;
}
