"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuthController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const auth_service_1 = require("../services/auth.service");
const response_1 = require("../utils/response");
let OAuthController = class OAuthController {
    service;
    constructor(service) {
        this.service = service;
    }
    redirectOAuthToMobile(request) {
        return {
            url: this.service.getMobileRedirect(request.url),
            statusCode: common_1.HttpStatus.TEMPORARY_REDIRECT,
        };
    }
    async startOAuth(dto, res, loginDetails) {
        const { url, state, codeVerifier } = await this.service.authorize(dto);
        return (0, response_1.respondWithCookie)(res, { url }, {
            isSecure: loginDetails.isSecure,
            values: [
                { key: enum_1.ImmichCookie.OAuthState, value: state },
                { key: enum_1.ImmichCookie.OAuthCodeVerifier, value: codeVerifier },
            ],
        });
    }
    async finishOAuth(request, res, dto, loginDetails) {
        const body = await this.service.callback(dto, request.headers, loginDetails);
        res.clearCookie(enum_1.ImmichCookie.OAuthState);
        res.clearCookie(enum_1.ImmichCookie.OAuthCodeVerifier);
        return (0, response_1.respondWithCookie)(res, body, {
            isSecure: loginDetails.isSecure,
            values: [
                { key: enum_1.ImmichCookie.AccessToken, value: body.accessToken },
                { key: enum_1.ImmichCookie.AuthType, value: enum_1.AuthType.OAuth },
                { key: enum_1.ImmichCookie.IsAuthenticated, value: 'true' },
            ],
        });
    }
    linkOAuthAccount(request, auth, dto) {
        return this.service.link(auth, dto, request.headers);
    }
    unlinkOAuthAccount(auth) {
        return this.service.unlink(auth);
    }
};
exports.OAuthController = OAuthController;
__decorate([
    (0, common_1.Get)('mobile-redirect'),
    (0, common_1.Redirect)(),
    (0, decorators_1.Endpoint)({
        summary: 'Redirect OAuth to mobile',
        description: 'Requests to this URL are automatically forwarded to the mobile app, and is used in some cases for OAuth redirecting.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200 }),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], OAuthController.prototype, "redirectOAuthToMobile", null);
__decorate([
    (0, common_1.Post)('authorize'),
    (0, decorators_1.Endpoint)({
        summary: 'Start OAuth',
        description: 'Initiate the OAuth authorization process.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/auth.dto").OAuthAuthorizeResponseDto }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __param(2, (0, auth_guard_1.GetLoginDetails)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.OAuthConfigDto, Object, Object]),
    __metadata("design:returntype", Promise)
], OAuthController.prototype, "startOAuth", null);
__decorate([
    (0, common_1.Post)('callback'),
    (0, decorators_1.Endpoint)({
        summary: 'Finish OAuth',
        description: 'Complete the OAuth authorization process by exchanging the authorization code for a session token.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/auth.dto").LoginResponseDto }),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __param(2, (0, common_1.Body)()),
    __param(3, (0, auth_guard_1.GetLoginDetails)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, auth_dto_1.OAuthCallbackDto, Object]),
    __metadata("design:returntype", Promise)
], OAuthController.prototype, "finishOAuth", null);
__decorate([
    (0, common_1.Post)('link'),
    (0, auth_guard_1.Authenticated)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Link OAuth account',
        description: 'Link an OAuth account to the authenticated user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, auth_guard_1.Auth)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, auth_dto_1.AuthDto,
        auth_dto_1.OAuthCallbackDto]),
    __metadata("design:returntype", Promise)
], OAuthController.prototype, "linkOAuthAccount", null);
__decorate([
    (0, common_1.Post)('unlink'),
    (0, auth_guard_1.Authenticated)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, decorators_1.Endpoint)({
        summary: 'Unlink OAuth account',
        description: 'Unlink the OAuth account from the authenticated user.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], OAuthController.prototype, "unlinkOAuthAccount", null);
exports.OAuthController = OAuthController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Authentication),
    (0, common_1.Controller)('oauth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService])
], OAuthController);
//# sourceMappingURL=oauth.controller.js.map