"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViewController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const view_service_1 = require("../services/view.service");
let ViewController = class ViewController {
    service;
    constructor(service) {
        this.service = service;
    }
    getUniqueOriginalPaths(auth) {
        return this.service.getUniqueOriginalPaths(auth);
    }
    getAssetsByOriginalPath(auth, path) {
        return this.service.getAssetsByOriginalPath(auth, path);
    }
};
exports.ViewController = ViewController;
__decorate([
    (0, common_1.Get)('folder/unique-paths'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.FolderRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve unique paths',
        description: 'Retrieve a list of unique folder paths from asset original paths.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [String] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], ViewController.prototype, "getUniqueOriginalPaths", null);
__decorate([
    (0, common_1.Get)('folder'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.FolderRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve assets by original path',
        description: 'Retrieve assets that are children of a specific folder.',
        history: new decorators_1.HistoryBuilder().added('v1').beta('v1').stable('v2'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-response.dto").AssetResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)('path')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, String]),
    __metadata("design:returntype", Promise)
], ViewController.prototype, "getAssetsByOriginalPath", null);
exports.ViewController = ViewController = __decorate([
    (0, swagger_1.ApiTags)(enum_1.ApiTag.Views),
    (0, common_1.Controller)('view'),
    __metadata("design:paramtypes", [view_service_1.ViewService])
], ViewController);
//# sourceMappingURL=view.controller.js.map