"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapAlbumWithoutAssets = exports.mapAlbumWithAssets = exports.mapAlbum = exports.AlbumResponseDto = exports.ContributorCountResponseDto = exports.AlbumUserResponseDto = exports.UpdateAlbumUserDto = exports.AlbumStatisticsResponseDto = exports.GetAlbumsDto = exports.UpdateAlbumDto = exports.AlbumsAddAssetsResponseDto = exports.AlbumsAddAssetsDto = exports.CreateAlbumDto = exports.AlbumUserCreateDto = exports.AddUsersDto = exports.AlbumUserAddDto = exports.AlbumInfoDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const lodash_1 = __importDefault(require("lodash"));
const asset_ids_response_dto_1 = require("./asset-ids.response.dto");
const asset_response_dto_1 = require("./asset-response.dto");
const user_dto_1 = require("./user.dto");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class AlbumInfoDto {
    withoutAssets;
    static _OPENAPI_METADATA_FACTORY() {
        return { withoutAssets: { required: false, type: () => Boolean } };
    }
}
exports.AlbumInfoDto = AlbumInfoDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Exclude assets from response' }),
    __metadata("design:type", Boolean)
], AlbumInfoDto.prototype, "withoutAssets", void 0);
class AlbumUserAddDto {
    userId;
    role;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String }, role: { required: false, enum: require("../enum").AlbumUserRole } };
    }
}
exports.AlbumUserAddDto = AlbumUserAddDto;
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'User ID' }),
    __metadata("design:type", String)
], AlbumUserAddDto.prototype, "userId", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({
        enum: enum_1.AlbumUserRole,
        name: 'AlbumUserRole',
        description: 'Album user role',
        default: enum_1.AlbumUserRole.Editor,
    }),
    __metadata("design:type", String)
], AlbumUserAddDto.prototype, "role", void 0);
class AddUsersDto {
    albumUsers;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumUsers: { required: true, type: () => [require("./album.dto").AlbumUserAddDto], minItems: 1 } };
    }
}
exports.AddUsersDto = AddUsersDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Album users to add' }),
    (0, class_validator_1.ArrayNotEmpty)(),
    __metadata("design:type", Array)
], AddUsersDto.prototype, "albumUsers", void 0);
class AlbumUserCreateDto {
    userId;
    role;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String }, role: { required: true, enum: require("../enum").AlbumUserRole } };
    }
}
exports.AlbumUserCreateDto = AlbumUserCreateDto;
__decorate([
    (0, validation_1.ValidateUUID)({ description: 'User ID' }),
    __metadata("design:type", String)
], AlbumUserCreateDto.prototype, "userId", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AlbumUserRole, name: 'AlbumUserRole', description: 'Album user role' }),
    __metadata("design:type", String)
], AlbumUserCreateDto.prototype, "role", void 0);
class CreateAlbumDto {
    albumName;
    description;
    albumUsers;
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumName: { required: true, type: () => String }, description: { required: false, type: () => String }, albumUsers: { required: false, type: () => [require("./album.dto").AlbumUserCreateDto] }, assetIds: { required: false, type: () => [String] } };
    }
}
exports.CreateAlbumDto = CreateAlbumDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Album name' }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateAlbumDto.prototype, "albumName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Album description' }),
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    __metadata("design:type", String)
], CreateAlbumDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Album users' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => AlbumUserCreateDto),
    __metadata("design:type", Array)
], CreateAlbumDto.prototype, "albumUsers", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, each: true, description: 'Initial asset IDs' }),
    __metadata("design:type", Array)
], CreateAlbumDto.prototype, "assetIds", void 0);
class AlbumsAddAssetsDto {
    albumIds;
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumIds: { required: true, type: () => [String] }, assetIds: { required: true, type: () => [String] } };
    }
}
exports.AlbumsAddAssetsDto = AlbumsAddAssetsDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, description: 'Album IDs' }),
    __metadata("design:type", Array)
], AlbumsAddAssetsDto.prototype, "albumIds", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true, description: 'Asset IDs' }),
    __metadata("design:type", Array)
], AlbumsAddAssetsDto.prototype, "assetIds", void 0);
class AlbumsAddAssetsResponseDto {
    success;
    error;
    static _OPENAPI_METADATA_FACTORY() {
        return { success: { required: true, type: () => Boolean }, error: { required: false, enum: require("./asset-ids.response.dto").BulkIdErrorReason } };
    }
}
exports.AlbumsAddAssetsResponseDto = AlbumsAddAssetsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Operation success' }),
    __metadata("design:type", Boolean)
], AlbumsAddAssetsResponseDto.prototype, "success", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: asset_ids_response_dto_1.BulkIdErrorReason, name: 'BulkIdErrorReason', description: 'Error reason', optional: true }),
    __metadata("design:type", String)
], AlbumsAddAssetsResponseDto.prototype, "error", void 0);
class UpdateAlbumDto {
    albumName;
    description;
    albumThumbnailAssetId;
    isActivityEnabled;
    order;
    static _OPENAPI_METADATA_FACTORY() {
        return { albumName: { required: false, type: () => String }, description: { required: false, type: () => String }, albumThumbnailAssetId: { required: false, type: () => String }, isActivityEnabled: { required: false, type: () => Boolean }, order: { required: false, enum: require("../enum").AssetOrder } };
    }
}
exports.UpdateAlbumDto = UpdateAlbumDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Album name' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UpdateAlbumDto.prototype, "albumName", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Album description' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], UpdateAlbumDto.prototype, "description", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Album thumbnail asset ID' }),
    __metadata("design:type", String)
], UpdateAlbumDto.prototype, "albumThumbnailAssetId", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, description: 'Enable activity feed' }),
    __metadata("design:type", Boolean)
], UpdateAlbumDto.prototype, "isActivityEnabled", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetOrder, name: 'AssetOrder', description: 'Asset sort order', optional: true }),
    __metadata("design:type", String)
], UpdateAlbumDto.prototype, "order", void 0);
class GetAlbumsDto {
    shared;
    assetId;
    static _OPENAPI_METADATA_FACTORY() {
        return { shared: { required: false, type: () => Boolean }, assetId: { required: false, type: () => String } };
    }
}
exports.GetAlbumsDto = GetAlbumsDto;
__decorate([
    (0, validation_1.ValidateBoolean)({
        optional: true,
        description: 'Filter by shared status: true = only shared, false = not shared, undefined = all owned albums',
    }),
    __metadata("design:type", Boolean)
], GetAlbumsDto.prototype, "shared", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, description: 'Filter albums containing this asset ID (ignores shared parameter)' }),
    __metadata("design:type", String)
], GetAlbumsDto.prototype, "assetId", void 0);
class AlbumStatisticsResponseDto {
    owned;
    shared;
    notShared;
    static _OPENAPI_METADATA_FACTORY() {
        return { owned: { required: true, type: () => Number }, shared: { required: true, type: () => Number }, notShared: { required: true, type: () => Number } };
    }
}
exports.AlbumStatisticsResponseDto = AlbumStatisticsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of owned albums' }),
    __metadata("design:type", Number)
], AlbumStatisticsResponseDto.prototype, "owned", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of shared albums' }),
    __metadata("design:type", Number)
], AlbumStatisticsResponseDto.prototype, "shared", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of non-shared albums' }),
    __metadata("design:type", Number)
], AlbumStatisticsResponseDto.prototype, "notShared", void 0);
class UpdateAlbumUserDto {
    role;
    static _OPENAPI_METADATA_FACTORY() {
        return { role: { required: true, enum: require("../enum").AlbumUserRole } };
    }
}
exports.UpdateAlbumUserDto = UpdateAlbumUserDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AlbumUserRole, name: 'AlbumUserRole', description: 'Album user role' }),
    __metadata("design:type", String)
], UpdateAlbumUserDto.prototype, "role", void 0);
class AlbumUserResponseDto {
    user;
    role;
    static _OPENAPI_METADATA_FACTORY() {
        return { user: { required: true, type: () => require("./user.dto").UserResponseDto }, role: { required: true, enum: require("../enum").AlbumUserRole } };
    }
}
exports.AlbumUserResponseDto = AlbumUserResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", user_dto_1.UserResponseDto)
], AlbumUserResponseDto.prototype, "user", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AlbumUserRole, name: 'AlbumUserRole', description: 'Album user role' }),
    __metadata("design:type", String)
], AlbumUserResponseDto.prototype, "role", void 0);
class ContributorCountResponseDto {
    userId;
    assetCount;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: true, type: () => String }, assetCount: { required: true, type: () => Number } };
    }
}
exports.ContributorCountResponseDto = ContributorCountResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User ID' }),
    __metadata("design:type", String)
], ContributorCountResponseDto.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of assets contributed' }),
    __metadata("design:type", Number)
], ContributorCountResponseDto.prototype, "assetCount", void 0);
class AlbumResponseDto {
    id;
    ownerId;
    albumName;
    description;
    createdAt;
    updatedAt;
    albumThumbnailAssetId;
    shared;
    albumUsers;
    hasSharedLink;
    assets;
    owner;
    assetCount;
    lastModifiedAssetTimestamp;
    startDate;
    endDate;
    isActivityEnabled;
    order;
    contributorCounts;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, ownerId: { required: true, type: () => String }, albumName: { required: true, type: () => String }, description: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, albumThumbnailAssetId: { required: true, type: () => String, nullable: true }, shared: { required: true, type: () => Boolean }, albumUsers: { required: true, type: () => [require("./album.dto").AlbumUserResponseDto] }, hasSharedLink: { required: true, type: () => Boolean }, assets: { required: true, type: () => [require("./asset-response.dto").AssetResponseDto] }, owner: { required: true, type: () => require("./user.dto").UserResponseDto }, assetCount: { required: true, type: () => Number }, lastModifiedAssetTimestamp: { required: false, type: () => Date }, startDate: { required: false, type: () => Date }, endDate: { required: false, type: () => Date }, isActivityEnabled: { required: true, type: () => Boolean }, order: { required: false, enum: require("../enum").AssetOrder }, contributorCounts: { required: false, type: () => [require("./album.dto").ContributorCountResponseDto] } };
    }
}
exports.AlbumResponseDto = AlbumResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Album ID' }),
    __metadata("design:type", String)
], AlbumResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Owner user ID' }),
    __metadata("design:type", String)
], AlbumResponseDto.prototype, "ownerId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Album name' }),
    __metadata("design:type", String)
], AlbumResponseDto.prototype, "albumName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Album description' }),
    __metadata("design:type", String)
], AlbumResponseDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Creation date' }),
    __metadata("design:type", Date)
], AlbumResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Last update date' }),
    __metadata("design:type", Date)
], AlbumResponseDto.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Thumbnail asset ID' }),
    __metadata("design:type", Object)
], AlbumResponseDto.prototype, "albumThumbnailAssetId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Is shared album' }),
    __metadata("design:type", Boolean)
], AlbumResponseDto.prototype, "shared", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", Array)
], AlbumResponseDto.prototype, "albumUsers", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Has shared link' }),
    __metadata("design:type", Boolean)
], AlbumResponseDto.prototype, "hasSharedLink", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", Array)
], AlbumResponseDto.prototype, "assets", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: undefined }),
    __metadata("design:type", user_dto_1.UserResponseDto)
], AlbumResponseDto.prototype, "owner", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', description: 'Number of assets' }),
    __metadata("design:type", Number)
], AlbumResponseDto.prototype, "assetCount", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Last modified asset timestamp' }),
    __metadata("design:type", Date)
], AlbumResponseDto.prototype, "lastModifiedAssetTimestamp", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Start date (earliest asset)' }),
    __metadata("design:type", Date)
], AlbumResponseDto.prototype, "startDate", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'End date (latest asset)' }),
    __metadata("design:type", Date)
], AlbumResponseDto.prototype, "endDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Activity feed enabled' }),
    __metadata("design:type", Boolean)
], AlbumResponseDto.prototype, "isActivityEnabled", void 0);
__decorate([
    (0, validation_1.ValidateEnum)({ enum: enum_1.AssetOrder, name: 'AssetOrder', description: 'Asset sort order', optional: true }),
    __metadata("design:type", String)
], AlbumResponseDto.prototype, "order", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: undefined }),
    (0, class_transformer_1.Type)(() => ContributorCountResponseDto),
    __metadata("design:type", Array)
], AlbumResponseDto.prototype, "contributorCounts", void 0);
const mapAlbum = (entity, withAssets, auth) => {
    const albumUsers = [];
    if (entity.albumUsers) {
        for (const albumUser of entity.albumUsers) {
            const user = (0, user_dto_1.mapUser)(albumUser.user);
            albumUsers.push({
                user,
                role: albumUser.role,
            });
        }
    }
    const albumUsersSorted = lodash_1.default.orderBy(albumUsers, ['role', 'user.name']);
    const assets = entity.assets || [];
    const hasSharedLink = !!entity.sharedLinks && entity.sharedLinks.length > 0;
    const hasSharedUser = albumUsers.length > 0;
    let startDate = assets.at(0)?.localDateTime;
    let endDate = assets.at(-1)?.localDateTime;
    if (startDate && endDate && startDate > endDate) {
        [startDate, endDate] = [endDate, startDate];
    }
    return {
        albumName: entity.albumName,
        description: entity.description,
        albumThumbnailAssetId: entity.albumThumbnailAssetId,
        createdAt: entity.createdAt,
        updatedAt: entity.updatedAt,
        id: entity.id,
        ownerId: entity.ownerId,
        owner: (0, user_dto_1.mapUser)(entity.owner),
        albumUsers: albumUsersSorted,
        shared: hasSharedUser || hasSharedLink,
        hasSharedLink,
        startDate,
        endDate,
        assets: (withAssets ? assets : []).map((asset) => (0, asset_response_dto_1.mapAsset)(asset, { auth })),
        assetCount: entity.assets?.length || 0,
        isActivityEnabled: entity.isActivityEnabled,
        order: entity.order,
    };
};
exports.mapAlbum = mapAlbum;
const mapAlbumWithAssets = (entity) => (0, exports.mapAlbum)(entity, true);
exports.mapAlbumWithAssets = mapAlbumWithAssets;
const mapAlbumWithoutAssets = (entity) => (0, exports.mapAlbum)(entity, false);
exports.mapAlbumWithoutAssets = mapAlbumWithoutAssets;
//# sourceMappingURL=album.dto.js.map